<?php

namespace WordpressModels\ORM\EntityRepository;

use Doctrine\ORM\EntityRepository;
use WordpressModels\ORM\Entity\Comment;
use WordpressModels\ORM\WooCommerceEntity\Order;

class OrderRepository extends EntityRepository
{

    public function getNotes(Order $order): array
    {
        // find the cache region for this entity
        $cacheRegion = $this->getEntityManager()->getCache()->getEntityCacheRegion(Order::class);

        $queryBuilder = $this->getEntityManager()
            ->getRepository(Comment::class)
            ->createQueryBuilder('c')
            ->where('c.objectId = :orderId')
            ->andWhere('c.type = :type')
            ->setParameter('orderId', $order->getId())
            ->setParameter('type', 'order_note')
            ->orderBy('c.createdAt', 'DESC');

        return $queryBuilder
            ->getQuery()
            ->setCacheable(true)
            ->setCacheRegion($cacheRegion)
            ->enableResultCache()
            ->getResult();
    }

}