<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\WooCommerceEntity;

use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\JoinColumn;
use Doctrine\ORM\Mapping\ManyToOne;
use Doctrine\ORM\Mapping\Table;
use WordpressModels\ORM\Entity\AbstractMeta;


/**
 * Doctrine Entity matching the wp_woocommerce_order_itemmeta table.
 */
#[Entity]
#[Table(name: 'order_itemmeta')]
class OrderItemMeta extends AbstractMeta
{

    #[ManyToOne(targetEntity: OrderItem::class, inversedBy: 'meta')]
    #[JoinColumn(name: 'order_item_id', referencedColumnName: 'order_item_id')]
    private OrderItem $orderItem;

    /**
     * @return OrderItem
     */
    public function getOrderItem(): OrderItem
    {
        return $this->orderItem;
    }

    /**
     * @param OrderItem $orderItem
     * @return OrderItemMeta
     */
    public function setOrderItem(OrderItem $orderItem): OrderItemMeta
    {
        $this->orderItem = $orderItem;
        return $this;
    }

    public static function getType(): string
    {
        return 'order_item';
    }
}
