<?php

namespace WordpressModels\DependencyInjection\HookAttributes\Attributes;

abstract class Hook
{

    /**
     * @param string $type -- The type of hook to register (action|filter)
     * @psalm-param 'action'|'filter' $type
     * @param string $hook -- The hook to register
     * @param int $priority -- The priority of the hook
     * @param int|null $accepted_args -- The number of arguments the hook accepts
     * @param string|null $when -- The hook to register this hook on
     * @param bool $admin -- Whether the hook should only be registered in the admin
     */
    public function __construct(
        public readonly string  $type,
        public readonly string  $hook,
        public readonly int     $priority = 10,
        public readonly ?int    $accepted_args = null,
        public readonly ?string $when = null,
        public readonly bool    $admin = false,
    )
    {
    }

}