"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[740],{

/***/ 51740:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailSectionsListRoute)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./node_modules/@fortawesome/react-fontawesome/index.es.js + 1 modules
var index_es = __webpack_require__(70982);
// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/faListCheck.js
var faListCheck = __webpack_require__(80443);
// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/faHeading.js
var faHeading = __webpack_require__(68705);
// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/faTimes.js
var faTimes = __webpack_require__(59545);
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(94184);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
// EXTERNAL MODULE: ./assets/src/js/react/lib/rjsf/SchemaForm/index.tsx + 29 modules
var SchemaForm = __webpack_require__(63610);
;// CONCATENATED MODULE: ./assets/src/js/schema/email-section.schema.json
const email_section_schema_namespaceObject = JSON.parse('{"title":"Email Section","type":"object","properties":{"title":{"title":"Title","type":"string"},"enable":{"title":"Enable Section","type":"boolean"},"showTitle":{"title":"Show Title","type":"boolean"},"text":{"title":"Text","type":"string"},"condition":{"title":"Condition","$ref":"#/definitions/condition"}},"definitions":{"condition":{"type":"null"}}}');
;// CONCATENATED MODULE: ./assets/src/js/schema/email-section.uiSchema.json
const email_section_uiSchema_namespaceObject = JSON.parse('{"ui:options":{"fieldsetProperties":{"className":"form-grid grid-cols-2"},"submitButtonOptions":{"norender":true}},"title":{"classNames":"col-span-full"},"text":{"classNames":"col-span-full","ui:widget":"RichTextWidget"},"enable":{"classNames":"col-span-1"},"showTitle":{"classNames":"col-span-1"},"condition":{"classNames":"col-span-full","items":{"hideLabel":true,"function":{"title":"Function"},"arguments":{"hideLabel":true}}}}');
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/faTrash.js
var faTrash = __webpack_require__(42619);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionEdit.tsx








/* harmony default export */ const EmailSectionEdit = ((0,external_React_.forwardRef)(function ({ email, section, onSectionChange, onDelete }, ref) {
    const { data: conditionFunctionSchema } = (0,datafetching_email/* useConditionFunctions */.cq)(email);
    const memoizedData = external_React_default().useMemo(() => {
        return {
            ...section,
            condition: conditionFunctionSchema?.type === 'null' ? null : section.condition
        };
    }, [section, conditionFunctionSchema]);
    const memoizedSchema = external_React_default().useMemo(() => {
        const newSchema = structuredClone(email_section_schema_namespaceObject);
        if (!newSchema.definitions) {
            newSchema.definitions = {};
        }
        if (conditionFunctionSchema) {
            newSchema.definitions.condition = conditionFunctionSchema;
        }
        if (section.builtIn) {
            delete newSchema.properties.title;
            delete newSchema.properties.showTitle;
            delete newSchema.properties.text;
        }
        return newSchema;
    }, [conditionFunctionSchema]);
    const onChange = external_React_default().useCallback((data) => {
        const newSection = structuredClone(section);
        data.formData && Object.assign(newSection, data.formData);
        if (memoizedSchema.properties?.condition?.type === 'null') {
            newSection.condition = null;
        }
        onSectionChange(newSection);
    }, [section]);
    const omitEmptyNonRequiredFields = external_React_default().useCallback((formData, errors) => {
        if (!formData) {
            return errors;
        }
        Object.keys(formData).forEach((key) => {
            const value = formData[key];
            if (value === undefined || value === null || value === '' && memoizedSchema.required?.includes(key) === false) {
                delete formData[key];
            }
        });
        return errors;
    }, [memoizedSchema]);
    return external_React_default().createElement((external_React_default()).Fragment, null,
        external_React_default().createElement(react.Card, null,
            external_React_default().createElement("div", { className: 'absolute w-full flex justify-end' },
                external_React_default().createElement(react.Button, { color: 'red', className: '!p-2 flex-grow-0 !rounded-l-0', onClick: onDelete, title: 'Delete' },
                    external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: faTrash/* faTrash */.$ }))),
            external_React_default().createElement(react.CardBody, null,
                external_React_default().createElement(SchemaForm/* default */.Z, { idPrefix: section.id || 'new', schema: memoizedSchema, customValidate: omitEmptyNonRequiredFields, uiSchema: email_section_uiSchema_namespaceObject, data: memoizedData, onChange: onChange, ref: ref }))));
}));

// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/faCode.js
var faCode = __webpack_require__(75213);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionAccordion.tsx









/* harmony default export */ const EmailSectionAccordion = (external_React_default().forwardRef(function ({ open: _open, email, section, onSectionChange }, ref) {
    const [open, setOpen] = external_React_default().useState(_open ?? false);
    (0,external_React_.useEffect)(() => {
        const refObj = ref;
        if (refObj.current) {
            refObj.current.setOpen = setOpen;
        }
    }, [ref]);
    return external_React_default().createElement(react.Accordion, { open: open },
        external_React_default().createElement(react.AccordionHeader, { className: classnames_default()('text-base xl:text-lg py-3 px-2 anchor', {
                'text-gray-400': !section.enable,
            }), title: section.enable ? section.title : 'This section is disabled', onClick: () => setOpen(currentState => !currentState) },
            section.title,
            external_React_default().createElement("div", { className: 'text-end flex-grow group flex gap-2 justify-end' },
                Boolean(section.condition?.length) &&
                    external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { className: 'text-red-900 group-hover:text-red-700', title: 'This section is conditional', icon: faListCheck/* faListCheck */.jM }),
                section.showTitle &&
                    external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { title: 'This displays its title', icon: faHeading/* faHeading */.gH }),
                !section.enable &&
                    external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: faTimes/* faTimes */.NB, className: 'text-red-900 group-hover:text-red-700', title: 'This section is disabled' }),
                section.builtIn &&
                    external_React_default().createElement(index_es/* FontAwesomeIcon */.G, { icon: faCode/* faCode */.dT, title: 'Built-in section' }))),
        external_React_default().createElement(react.AccordionBody, { className: 'body' }, open && external_React_default().createElement(EmailSectionEdit, { email: email, section: section, onSectionChange: section => onSectionChange(section?.id, section), onDelete: () => onSectionChange(section.id), ref: ref })));
}));

// EXTERNAL MODULE: ./node_modules/react-sortablejs/dist/index.js
var react_sortablejs_dist = __webpack_require__(16941);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionsList/styles.module.scss
// extracted by mini-css-extract-plugin
/* harmony default export */ const styles_module = ({"chosen":"vB7Tojkh8WD83vEb06p0","ghost":"BZFBbvhZ7in7aIKyWaFC"});
// EXTERNAL MODULE: ./assets/src/js/react/lib/actions/email.ts
var actions_email = __webpack_require__(72926);
// EXTERNAL MODULE: ./node_modules/crypto-random-string/browser.js + 1 modules
var browser = __webpack_require__(45801);
// EXTERNAL MODULE: ./assets/src/js/react/lib/objectMod.ts
var objectMod = __webpack_require__(86560);
// EXTERNAL MODULE: external "ReactDOM"
var external_ReactDOM_ = __webpack_require__(91850);
// EXTERNAL MODULE: ./node_modules/react-select/dist/react-select.esm.js + 49 modules
var react_select_esm = __webpack_require__(58630);
// EXTERNAL MODULE: ./node_modules/js-convert-case/index.js
var js_convert_case = __webpack_require__(24417);
// EXTERNAL MODULE: ./node_modules/deep-object-diff/mjs/diff.js + 1 modules
var diff = __webpack_require__(41066);
;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSectionsList/index.tsx














const toast = window.toast;
function cleanupSection(section) {
    return { ...(0,objectMod/* omit */.F)(section, 'chosen', 'ghost', 'selected', 'filtered'), text: section.text.trim() };
}
/* harmony default export */ function EmailSectionsList({ email, onEmailUpdated, onEmailChanged }) {
    const [sections, setSections] = external_React_default().useState(email.sections);
    const [hasChanges, setHasChanges] = external_React_default().useState(false);
    const [builtInSectionModalOpen, setBuiltInSectionModalOpen] = external_React_default().useState(false);
    const { data: builtInSections, isLoading: isLoadingBuiltInSections } = (0,datafetching_email/* useBuiltInSections */.S)();
    const [selectedBuiltInSection, setSelectedBuiltInSection] = external_React_default().useState();
    const [savingSections, setSavingSections] = external_React_default().useState(false);
    const { isLoading: isLoadingConditions, isValidating: isValidatingConditions } = (0,datafetching_email/* useConditionFunctions */.cq)(email);
    const [toastId, setToastId] = external_React_default().useState(null);
    const memoizedIsLoadingConditions = external_React_default().useMemo(() => isLoadingConditions || isValidatingConditions, [isLoadingConditions, isValidatingConditions]);
    const revalidateEmails = (0,datafetching_email/* useEmailsMutate */.zv)();
    (0,external_React_.useEffect)(() => {
        if (!toast) {
            return;
        }
        if (!Boolean(toastId) && memoizedIsLoadingConditions) {
            setToastId(toast.loading('Loading conditions...', { duration: Infinity }));
        }
        else if (toastId && !memoizedIsLoadingConditions) {
            toast.dismiss();
            setToastId(null);
        }
    }, [memoizedIsLoadingConditions, toastId]);
    const sectionRefs = (0,external_React_.useMemo)(() => sections
        .reduce((carry, section) => ({
        ...carry,
        [section.id]: external_React_default().createRef()
    }), {}), [sections]);
    const onSectionChange = external_React_default().useCallback((id, section) => {
        const newSections = structuredClone(sections);
        const index = newSections.findIndex((s) => s.id === id);
        if (index !== -1) {
            if (!section) {
                newSections.splice(index, 1);
            }
            else {
                newSections[index] = section;
            }
        }
        else if (section !== undefined) {
            newSections.push(section);
        }
        let cleanAndOrderedSections = newSections.map((section, index) => ({
            ...cleanupSection(section),
            sortOrder: index
        }));
        setSections(cleanAndOrderedSections);
    }, [sections]);
    const onSaveSections = external_React_default().useCallback(() => {
        setSavingSections(true);
        const invalidSectionEntries = Object.entries(sectionRefs).filter(([_, ref]) => {
            return !(ref.current?.validateForm() ?? true);
        });
        if (Boolean(invalidSectionEntries.length)) {
            toast.error('One or more sections are invalid. Please fix them before saving.');
            setSavingSections(false);
            invalidSectionEntries.forEach(([_, ref]) => {
                ref.current?.setOpen(true);
            });
            return;
        }
        (0,actions_email/* saveEmail */.it)({ ...email, sections })
            .catch((error) => {
            toast.error('Error saving email sections: ' + error.message);
        })
            .then((email) => {
            toast.success('Email sections saved', { duration: 3000 });
            onEmailUpdated({ ...email, sections: sections.map(cleanupSection) });
            setSections(email.sections);
        })
            .finally(() => {
            setSavingSections(false);
            revalidateEmails();
        });
    }, [email, sections]);
    const addSection = external_React_default().useCallback((section = undefined) => {
        let id = (0,browser/* default */.Z)({ length: 10, type: 'url-safe' });
        let newSection = {
            id: id,
            title: 'New section',
            text: '',
            enable: true,
            showTitle: false,
            sortOrder: 0,
            condition: [],
            builtIn: false,
            ...(section ?? {})
        };
        onSectionChange(id, newSection);
        setBuiltInSectionModalOpen(false);
    }, [sections]);
    const setList = external_React_default().useCallback((newSections) => {
        let cleanedAndOrderedSections = newSections.map((section, index) => ({
            ...cleanupSection(section),
            sortOrder: index
        }));
        setSections(cleanedAndOrderedSections);
    }, [sections]);
    (0,external_React_.useEffect)(() => {
        if (sections) {
            const cleanSections = sections.map(cleanupSection);
            onEmailChanged({ ...email, sections: cleanSections });
            let changes = (0,diff/* default */.Z)(email.sections.map(cleanupSection), cleanSections);
            setHasChanges(Boolean(Object.keys(changes).length));
        }
    }, [sections]);
    return external_React_default().createElement((external_React_default()).Fragment, null,
        external_React_default().createElement(react.ButtonGroup, { size: 'sm', color: 'white', fullWidth: true },
            external_React_default().createElement(react.Button, { type: 'button', onClick: () => setBuiltInSectionModalOpen(prev => !prev) }, "Add Template Section"),
            external_React_default().createElement(react.Button, { color: 'blue-gray', type: 'button', onClick: () => addSection() }, "Add section"),
            external_React_default().createElement(react.Button, { color: 'blue-gray', type: 'button', disabled: !hasChanges || savingSections, onClick: onSaveSections }, savingSections ?
                external_React_default().createElement("span", { className: 'inline-flex' },
                    external_React_default().createElement(react.Spinner, { className: 'w-4 h-4 pr-1' }),
                    "Saving...") : 'Save')),
        external_React_default().createElement(react_sortablejs_dist.ReactSortable, { list: sections, setList: setList, ghostClass: styles_module.ghost, chosenClass: styles_module.chosen, animation: 150, delay: 50, handle: '.anchor' }, sections.map((section) => external_React_default().createElement(EmailSectionAccordion, { key: email.id + '-' + section.id, email: email, section: section, onSectionChange: onSectionChange, ref: sectionRefs[section.id] }))),
        (0,external_ReactDOM_.createPortal)(external_React_default().createElement(react.Dialog, { open: builtInSectionModalOpen, animate: {
                unmount: {},
                mount: {}
            }, handler: setBuiltInSectionModalOpen },
            external_React_default().createElement(react.DialogBody, null,
                external_React_default().createElement(react_select_esm/* default */.ZP, { options: builtInSections
                        ?.filter(s => !sections.find(section => section.id === s))
                        ?.map((section) => ({ value: section, label: (0,js_convert_case.toSentenceCase)(section) })), isLoading: isLoadingBuiltInSections, isMulti: false, onChange: (option) => {
                        setSelectedBuiltInSection(builtInSections?.find((section) => section === option?.value));
                    } })),
            external_React_default().createElement(react.DialogFooter, null,
                external_React_default().createElement(react.ButtonGroup, null,
                    external_React_default().createElement(react.Button, { color: 'red', onClick: () => setBuiltInSectionModalOpen(false) }, "Cancel"),
                    external_React_default().createElement(react.Button, { color: 'green', onClick: () => addSection({
                            id: selectedBuiltInSection,
                            title: (0,js_convert_case.toSentenceCase)(selectedBuiltInSection),
                            builtIn: true
                        }) }, "Add")))), document.body));
}

;// CONCATENATED MODULE: ./assets/src/js/react/routes/EmailSectionsListRoute.tsx



/* harmony default export */ function EmailSectionsListRoute() {
    const ctx = (0,dist/* useOutletContext */.bx)();
    const onUpdated = () => { };
    return external_React_default().createElement(EmailSectionsList, { key: ctx.email.id, email: ctx.email, onEmailChanged: onUpdated, onEmailUpdated: onUpdated });
}


/***/ })

}]);