<?php

namespace RTMCustomMails;

use Doctrine\Common\Annotations\AnnotationReader;
use Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory;
use Symfony\Component\Serializer\Mapping\Loader\AnnotationLoader;
use Symfony\Component\Serializer\Mapping\Loader\LoaderChain;
use Symfony\Component\Serializer\Mapping\Loader\YamlFileLoader;
use Symfony\Component\Serializer\Normalizer\AbstractObjectNormalizer;
use Symfony\Component\Serializer\Normalizer\BackedEnumNormalizer;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class SerializerFactory
{

    public static function create()
    {
        $loaderChain = new LoaderChain([
//            new YamlFileLoader(WRCE_ROOT_PATH . '/config/serializer.yaml'),
            new AnnotationLoader(new AnnotationReader()),
        ]);

        return new Serializer([
            new BackedEnumNormalizer(),
            new DateTimeNormalizer(),
            new ObjectNormalizer(
                classMetadataFactory: new ClassMetadataFactory($loaderChain),
                defaultContext: [
                    AbstractObjectNormalizer::SKIP_UNINITIALIZED_VALUES => true,
                    AbstractObjectNormalizer::SKIP_NULL_VALUES => false,
                ]
            )
        ]);
    }

}