"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[60],{

/***/ 11913:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Xo": () => (/* binding */ resolveDependencies),
/* harmony export */   "ZP": () => (/* binding */ retrieveSchema),
/* harmony export */   "rK": () => (/* binding */ resolveAllReferences)
/* harmony export */ });
/* unused harmony exports resolveCondition, getAllPermutationsOfXxxOf, resolveSchema, resolveReference, stubExistingAdditionalProperties, retrieveSchemaInternal, resolveAnyOrOneOfSchemas, processDependencies, withDependentProperties, withDependentSchema, withExactlyOneSubschema */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(70655);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27361);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36968);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98913);
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_times__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(68718);
/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_transform__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19830);
/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(27322);
/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(70160);
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(30683);
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(89887);
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(73999);
/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(91828);
/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(2944);













/** Retrieves an expanded schema that has had all of its conditions, additional properties, references and dependencies
 * resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData` that is used to do the
 * potentially recursive resolution.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param [rootSchema={}] - The root schema that will be forwarded to all the APIs
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
 * @returns - The schema having its conditions, additional properties, references and dependencies resolved
 */
function retrieveSchema(validator, schema, rootSchema = {}, rawFormData) {
    return retrieveSchemaInternal(validator, schema, rootSchema, rawFormData)[0];
}
/** Resolves a conditional block (if/else/then) by removing the condition and merging the appropriate conditional branch
 * with the rest of the schema. If `expandAllBranches` is true, then the `retrieveSchemaInteral()` results for both
 * conditions will be returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that is used to detect valid schema conditions
 * @param schema - The schema for which resolving a condition is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and
 *          dependencies as a list of schemas
 * @param [formData] - The current formData to assist retrieving a schema
 * @returns - A list of schemas with the appropriate conditions resolved, possibly with all branches expanded
 */
function resolveCondition(validator, schema, rootSchema, expandAllBranches, formData) {
    const { if: expression, then, else: otherwise } = schema, resolvedSchemaLessConditional = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__rest)(schema, ["if", "then", "else"]);
    const conditionValue = validator.isValid(expression, formData || {}, rootSchema);
    let resolvedSchemas = [resolvedSchemaLessConditional];
    let schemas = [];
    if (expandAllBranches) {
        if (then && typeof then !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, then, rootSchema, formData, expandAllBranches));
        }
        if (otherwise && typeof otherwise !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, otherwise, rootSchema, formData, expandAllBranches));
        }
    }
    else {
        const conditionalSchema = conditionValue ? then : otherwise;
        if (conditionalSchema && typeof conditionalSchema !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, conditionalSchema, rootSchema, formData, expandAllBranches));
        }
    }
    if (schemas.length) {
        resolvedSchemas = schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(resolvedSchemaLessConditional, s));
    }
    return resolvedSchemas.flatMap((s) => retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches));
}
/** Given a list of lists of allOf, anyOf or oneOf values, create a list of lists of all permutations of the values. The
 * `listOfLists` is expected to be all resolved values of the 1st...nth schemas within an `allOf`, `anyOf` or `oneOf`.
 * From those lists, build a matrix for each `xxxOf` where there is more than one schema for a row in the list of lists.
 *
 * For example:
 * - If there are three xxxOf rows (A, B, C) and they have been resolved such that there is only one A, two B and three
 *   C schemas then:
 *   - The permutation for the first row is `[[A]]`
 *   - The permutations for the second row are `[[A,B1], [A,B2]]`
 *   - The permutations for the third row are `[[A,B1,C1], [A,B1,C2], [A,B1,C3], [A,B2,C1], [A,B2,C2], [A,B2,C3]]`
 *
 * @param listOfLists - The list of lists of elements that represent the allOf, anyOf or oneOf resolved values in order
 * @returns - The list of all permutations of schemas for a set of `xxxOf`s
 */
function getAllPermutationsOfXxxOf(listOfLists) {
    const allPermutations = listOfLists.reduce((permutations, list) => {
        // When there are more than one set of schemas for a row, duplicate the set of permutations and add in the values
        if (list.length > 1) {
            return list.flatMap((element) => lodash_times__WEBPACK_IMPORTED_MODULE_2___default()(permutations.length, (i) => [...permutations[i]].concat(element)));
        }
        // Otherwise just push in the single value into the current set of permutations
        permutations.forEach((permutation) => permutation.push(list[0]));
        return permutations;
    }, [[]] // Start with an empty list
    );
    return allPermutations;
}
/** Resolves references and dependencies within a schema and its 'allOf' children. Passes the `expandAllBranches` flag
 * down to the `retrieveSchemaInternal()`, `resolveReference()` and `resolveDependencies()` helper calls. If
 * `expandAllBranches` is true, then all possible dependencies and/or allOf branches are returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list of schemas having its references, dependencies and allOf schemas resolved
 */
function resolveSchema(validator, schema, rootSchema, expandAllBranches, formData) {
    if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .REF_KEY */ .Sr in schema) {
        return resolveReference(validator, schema, rootSchema, expandAllBranches, formData);
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .DEPENDENCIES_KEY */ .LL in schema) {
        const resolvedSchemas = resolveDependencies(validator, schema, rootSchema, expandAllBranches, formData);
        return resolvedSchemas.flatMap((s) => {
            return retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches);
        });
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .ALL_OF_KEY */ .OA in schema && Array.isArray(schema.allOf)) {
        const allOfSchemaElements = schema.allOf.map((allOfSubschema) => retrieveSchemaInternal(validator, allOfSubschema, rootSchema, formData, expandAllBranches));
        const allPermutations = getAllPermutationsOfXxxOf(allOfSchemaElements);
        return allPermutations.map((permutation) => (Object.assign(Object.assign({}, schema), { allOf: permutation })));
    }
    // No $ref or dependencies or allOf attribute was found, returning the original schema.
    return [schema];
}
/** Resolves references within a schema and then returns the `retrieveSchemaInternal()` of the resolved schema. Passes
 * the `expandAllBranches` flag down to the `retrieveSchemaInternal()` helper call.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a reference is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list schemas retrieved after having all references resolved
 */
function resolveReference(validator, schema, rootSchema, expandAllBranches, formData) {
    // Drop the $ref property of the source schema.
    const { $ref } = schema, localSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__rest)(schema, ["$ref"]);
    // Retrieve the referenced schema definition.
    const refSchema = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)($ref, rootSchema);
    // Update referenced schema definition with local schema properties.
    return retrieveSchemaInternal(validator, Object.assign(Object.assign({}, refSchema), localSchema), rootSchema, formData, expandAllBranches);
}
/** Resolves all references within a schema's properties and array items.
 *
 * @param schema - The schema for which resolving all references is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @returns - given schema will all references resolved
 */
function resolveAllReferences(schema, rootSchema) {
    let resolvedSchema = schema;
    // resolve top level ref
    if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .REF_KEY */ .Sr in resolvedSchema) {
        const { $ref } = resolvedSchema, localSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__rest)(resolvedSchema, ["$ref"]);
        // Retrieve the referenced schema definition.
        const refSchema = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)($ref, rootSchema);
        resolvedSchema = Object.assign(Object.assign({}, refSchema), localSchema);
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .PROPERTIES_KEY */ .MA in resolvedSchema) {
        const updatedProps = lodash_transform__WEBPACK_IMPORTED_MODULE_3___default()(resolvedSchema[_constants__WEBPACK_IMPORTED_MODULE_10__/* .PROPERTIES_KEY */ .MA], (result, value, key) => {
            result[key] = resolveAllReferences(value, rootSchema);
        }, {});
        resolvedSchema = Object.assign(Object.assign({}, resolvedSchema), { [_constants__WEBPACK_IMPORTED_MODULE_10__/* .PROPERTIES_KEY */ .MA]: updatedProps });
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .ITEMS_KEY */ .YU in resolvedSchema &&
        !Array.isArray(resolvedSchema.items) &&
        typeof resolvedSchema.items !== 'boolean') {
        resolvedSchema = Object.assign(Object.assign({}, resolvedSchema), { items: resolveAllReferences(resolvedSchema.items, rootSchema) });
    }
    return resolvedSchema;
}
/** Creates new 'properties' items for each key in the `formData`
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param theSchema - The schema for which the existing additional properties is desired
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s * @param validator
 * @param [aFormData] - The current formData, if any, to assist retrieving a schema
 * @returns - The updated schema with additional properties stubbed
 */
function stubExistingAdditionalProperties(validator, theSchema, rootSchema, aFormData) {
    // Clone the schema so that we don't ruin the consumer's original
    const schema = Object.assign(Object.assign({}, theSchema), { properties: Object.assign({}, theSchema.properties) });
    // make sure formData is an object
    const formData = aFormData && (0,_isObject__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z)(aFormData) ? aFormData : {};
    Object.keys(formData).forEach((key) => {
        if (key in schema.properties) {
            // No need to stub, our schema already has the property
            return;
        }
        let additionalProperties = {};
        if (typeof schema.additionalProperties !== 'boolean') {
            if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .REF_KEY */ .Sr in schema.additionalProperties) {
                additionalProperties = retrieveSchema(validator, { $ref: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema.additionalProperties, [_constants__WEBPACK_IMPORTED_MODULE_10__/* .REF_KEY */ .Sr]) }, rootSchema, formData);
            }
            else if ('type' in schema.additionalProperties) {
                additionalProperties = Object.assign({}, schema.additionalProperties);
            }
            else if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .ANY_OF_KEY */ .F8 in schema.additionalProperties || _constants__WEBPACK_IMPORTED_MODULE_10__/* .ONE_OF_KEY */ .If in schema.additionalProperties) {
                additionalProperties = Object.assign({ type: 'object' }, schema.additionalProperties);
            }
            else {
                additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z)(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };
            }
        }
        else {
            additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z)(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };
        }
        // The type of our new key should match the additionalProperties value;
        schema.properties[key] = additionalProperties;
        // Set our additional property flag so we know it was dynamically added
        lodash_set__WEBPACK_IMPORTED_MODULE_1___default()(schema.properties, [key, _constants__WEBPACK_IMPORTED_MODULE_10__/* .ADDITIONAL_PROPERTY_FLAG */ .jk], true);
    });
    return schema;
}
/** Internal handler that retrieves an expanded schema that has had all of its conditions, additional properties,
 * references and dependencies resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData`
 * that is used to do the potentially recursive resolution. If `expandAllBranches` is true, then all possible branches
 * of the schema and its references, conditions and dependencies are returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
 * @param [expandAllBranches=false] - Flag, if true, will return all possible branches of conditions, any/oneOf and
 *          dependencies as a list of schemas
 * @returns - The schema(s) resulting from having its conditions, additional properties, references and dependencies
 *          resolved. Multiple schemas may be returned if `expandAllBranches` is true.
 */
function retrieveSchemaInternal(validator, schema, rootSchema, rawFormData, expandAllBranches = false) {
    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z)(schema)) {
        return [{}];
    }
    const resolvedSchemas = resolveSchema(validator, schema, rootSchema, expandAllBranches, rawFormData);
    return resolvedSchemas.flatMap((s) => {
        let resolvedSchema = s;
        if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .IF_KEY */ .fx in resolvedSchema) {
            return resolveCondition(validator, resolvedSchema, rootSchema, expandAllBranches, rawFormData);
        }
        if (_constants__WEBPACK_IMPORTED_MODULE_10__/* .ALL_OF_KEY */ .OA in resolvedSchema) {
            // resolve allOf schemas
            if (expandAllBranches) {
                return [...resolvedSchema.allOf];
            }
            try {
                resolvedSchema = json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_4___default()(resolvedSchema, {
                    deep: false,
                });
            }
            catch (e) {
                console.warn('could not merge subschemas in allOf:\n', e);
                const { allOf } = resolvedSchema, resolvedSchemaWithoutAllOf = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__rest)(resolvedSchema, ["allOf"]);
                return resolvedSchemaWithoutAllOf;
            }
        }
        const hasAdditionalProperties = _constants__WEBPACK_IMPORTED_MODULE_10__/* .ADDITIONAL_PROPERTIES_KEY */ .iA in resolvedSchema && resolvedSchema.additionalProperties !== false;
        if (hasAdditionalProperties) {
            return stubExistingAdditionalProperties(validator, resolvedSchema, rootSchema, rawFormData);
        }
        return resolvedSchema;
    });
}
/** Resolves an `anyOf` or `oneOf` within a schema (if present) to the list of schemas returned from
 * `retrieveSchemaInternal()` for the best matching option. If `expandAllBranches` is true, then a list of schemas for ALL
 * options are retrieved and returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema, defaults to an empty object
 * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true
 */
function resolveAnyOrOneOfSchemas(validator, schema, rootSchema, expandAllBranches, rawFormData) {
    let anyOrOneOf;
    const { oneOf, anyOf } = schema, remaining = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__rest)(schema, ["oneOf", "anyOf"]);
    if (Array.isArray(oneOf)) {
        anyOrOneOf = oneOf;
    }
    else if (Array.isArray(anyOf)) {
        anyOrOneOf = anyOf;
    }
    if (anyOrOneOf) {
        // Ensure that during expand all branches we pass an object rather than undefined so that all options are interrogated
        const formData = rawFormData === undefined && expandAllBranches ? {} : rawFormData;
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(schema);
        anyOrOneOf = anyOrOneOf.map((s) => {
            return resolveAllReferences(s, rootSchema);
        });
        // Call this to trigger the set of isValid() calls that the schema parser will need
        const option = (0,_getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)(validator, formData, anyOrOneOf, rootSchema, discriminator);
        if (expandAllBranches) {
            return anyOrOneOf.map((item) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(remaining, item));
        }
        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(remaining, anyOrOneOf[option]);
    }
    return [schema];
}
/** Resolves dependencies within a schema and its 'anyOf/oneOf' children. Passes the `expandAllBranches` flag down to
 * the `resolveAnyOrOneOfSchema()` and `processDependencies()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a dependency is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list of schemas with their dependencies resolved
 */
function resolveDependencies(validator, schema, rootSchema, expandAllBranches, formData) {
    // Drop the dependencies from the source schema.
    const { dependencies } = schema, remainingSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__rest)(schema, ["dependencies"]);
    const resolvedSchemas = resolveAnyOrOneOfSchemas(validator, remainingSchema, rootSchema, expandAllBranches, formData);
    return resolvedSchemas.flatMap((resolvedSchema) => processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, formData));
}
/** Processes all the `dependencies` recursively into the list of `resolvedSchema`s as needed. Passes the
 * `expandAllBranches` flag down to the `withDependentSchema()` and the recursive `processDependencies()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param dependencies - The set of dependencies that needs to be processed
 * @param resolvedSchema - The schema for which processing dependencies is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The schema with the `dependencies` resolved into it
 */
function processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, formData) {
    let schemas = [resolvedSchema];
    // Process dependencies updating the local schema properties as appropriate.
    for (const dependencyKey in dependencies) {
        // Skip this dependency if its trigger property is not present.
        if (!expandAllBranches && lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [dependencyKey]) === undefined) {
            continue;
        }
        // Skip this dependency if it is not included in the schema (such as when dependencyKey is itself a hidden dependency.)
        if (resolvedSchema.properties && !(dependencyKey in resolvedSchema.properties)) {
            continue;
        }
        const [remainingDependencies, dependencyValue] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_5__/* .splitKeyElementFromObject */ .I)(dependencyKey, dependencies);
        if (Array.isArray(dependencyValue)) {
            schemas[0] = withDependentProperties(resolvedSchema, dependencyValue);
        }
        else if ((0,_isObject__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z)(dependencyValue)) {
            schemas = withDependentSchema(validator, resolvedSchema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, formData);
        }
        return schemas.flatMap((schema) => processDependencies(validator, remainingDependencies, schema, rootSchema, expandAllBranches, formData));
    }
    return schemas;
}
/** Updates a schema with additionally required properties added
 *
 * @param schema - The schema for which resolving a dependent properties is desired
 * @param [additionallyRequired] - An optional array of additionally required names
 * @returns - The schema with the additional required values merged in
 */
function withDependentProperties(schema, additionallyRequired) {
    if (!additionallyRequired) {
        return schema;
    }
    const required = Array.isArray(schema.required)
        ? Array.from(new Set([...schema.required, ...additionallyRequired]))
        : additionallyRequired;
    return Object.assign(Object.assign({}, schema), { required: required });
}
/** Merges a dependent schema into the `schema` dealing with oneOfs and references. Passes the `expandAllBranches` flag
 * down to the `retrieveSchemaInternal()`, `resolveReference()` and `withExactlyOneSubschema()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a dependent schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param dependencyKey - The key name of the dependency
 * @param dependencyValue - The potentially dependent schema
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [formData]- The current formData to assist retrieving a schema
 * @returns - The list of schemas with the dependent schema resolved into them
 */
function withDependentSchema(validator, schema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, formData) {
    const dependentSchemas = retrieveSchemaInternal(validator, dependencyValue, rootSchema, formData, expandAllBranches);
    return dependentSchemas.flatMap((dependent) => {
        const { oneOf } = dependent, dependentSchema = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__rest)(dependent, ["oneOf"]);
        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(schema, dependentSchema);
        // Since it does not contain oneOf, we return the original schema.
        if (oneOf === undefined) {
            return schema;
        }
        // Resolve $refs inside oneOf.
        const resolvedOneOfs = oneOf.map((subschema) => {
            if (typeof subschema === 'boolean' || !(_constants__WEBPACK_IMPORTED_MODULE_10__/* .REF_KEY */ .Sr in subschema)) {
                return [subschema];
            }
            return resolveReference(validator, subschema, rootSchema, expandAllBranches, formData);
        });
        const allPermutations = getAllPermutationsOfXxxOf(resolvedOneOfs);
        return allPermutations.flatMap((resolvedOneOf) => withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, resolvedOneOf, expandAllBranches, formData));
    });
}
/** Returns a list of `schema`s with the best choice from the `oneOf` options merged into it. If `expandAllBranches` is
 * true, then a list of schemas for ALL options are retrieved and returned. Passes the `expandAllBranches` flag down to
 * the `retrieveSchemaInternal()` helper call.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used to validate oneOf options
 * @param schema - The schema for which resolving a oneOf subschema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param dependencyKey - The key name of the oneOf dependency
 * @param oneOf - The list of schemas representing the oneOf options
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [formData] - The current formData to assist retrieving a schema
 * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true
 */
function withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, oneOf, expandAllBranches, formData) {
    const validSubschemas = oneOf.filter((subschema) => {
        if (typeof subschema === 'boolean' || !subschema || !subschema.properties) {
            return false;
        }
        const { [dependencyKey]: conditionPropertySchema } = subschema.properties;
        if (conditionPropertySchema) {
            const conditionSchema = {
                type: 'object',
                properties: {
                    [dependencyKey]: conditionPropertySchema,
                },
            };
            return validator.isValid(conditionSchema, formData, rootSchema) || expandAllBranches;
        }
        return false;
    });
    if (!expandAllBranches && validSubschemas.length !== 1) {
        console.warn("ignoring oneOf in dependencies because there isn't exactly one subschema that is valid");
        return [schema];
    }
    return validSubschemas.flatMap((s) => {
        const subschema = s;
        const [dependentSubschema] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_5__/* .splitKeyElementFromObject */ .I)(dependencyKey, subschema.properties);
        const dependentSchema = Object.assign(Object.assign({}, subschema), { properties: dependentSubschema });
        const schemas = retrieveSchemaInternal(validator, dependentSchema, rootSchema, formData, expandAllBranches);
        return schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(schema, s));
    });
}
//# sourceMappingURL=retrieveSchema.js.map

/***/ })

}]);