"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([["defaultVendors-1010~1012-0e9b0f38a28a46572ba1c90aa6b59152-ArrayField.js"],{

/***/ 58821:
/*!*********************************************************************!*\
  !*** ./node_modules/@rjsf/core/lib/components/fields/ArrayField.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 70655);\n/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ 85893);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ 99196);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ 64192);\n/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/cloneDeep */ 50361);\n/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/get */ 27361);\n/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isObject */ 13218);\n/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/set */ 36968);\n/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! nanoid */ 53416);\n\n\n\n\n\n\n\n\n\n/** Used to generate a unique ID for an element in a row */\nfunction generateRowId() {\n    return (0,nanoid__WEBPACK_IMPORTED_MODULE_7__.nanoid)();\n}\n/** Converts the `formData` into `KeyedFormDataType` data, using the `generateRowId()` function to create the key\n *\n * @param formData - The data for the form\n * @returns - The `formData` converted into a `KeyedFormDataType` element\n */\nfunction generateKeyedFormData(formData) {\n    return !Array.isArray(formData)\n        ? []\n        : formData.map((item) => {\n            return {\n                key: generateRowId(),\n                item,\n            };\n        });\n}\n/** Converts `KeyedFormDataType` data into the inner `formData`\n *\n * @param keyedFormData - The `KeyedFormDataType` to be converted\n * @returns - The inner `formData` item(s) in the `keyedFormData`\n */\nfunction keyedToPlainFormData(keyedFormData) {\n    if (Array.isArray(keyedFormData)) {\n        return keyedFormData.map((keyedItem) => keyedItem.item);\n    }\n    return [];\n}\n/** The `ArrayField` component is used to render a field in the schema that is of type `array`. It supports both normal\n * and fixed array, allowing user to add and remove elements from the array data.\n */\nclass ArrayField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {\n    /** Constructs an `ArrayField` from the `props`, generating the initial keyed data from the `formData`\n     *\n     * @param props - The `FieldProps` for this template\n     */\n    constructor(props) {\n        super(props);\n        /** Returns the default form information for an item based on the schema for that item. Deals with the possibility\n         * that the schema is fixed and allows additional items.\n         */\n        this._getNewFormDataRow = () => {\n            const { schema, registry } = this.props;\n            const { schemaUtils } = registry;\n            let itemSchema = schema.items;\n            if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isFixedItems)(schema) && (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.allowAdditionalItems)(schema)) {\n                itemSchema = schema.additionalItems;\n            }\n            // Cast this as a T to work around schema utils being for T[] caused by the FieldProps<T[], S, F> call on the class\n            return schemaUtils.getDefaultFormState(itemSchema);\n        };\n        /** Callback handler for when the user clicks on the add button. Creates a new row of keyed form data at the end of\n         * the list, adding it into the state, and then returning `onChange()` with the plain form data converted from the\n         * keyed data\n         *\n         * @param event - The event for the click\n         */\n        this.onAddClick = (event) => {\n            this._handleAddClick(event);\n        };\n        /** Callback handler for when the user clicks on the add button on an existing array element. Creates a new row of\n         * keyed form data inserted at the `index`, adding it into the state, and then returning `onChange()` with the plain\n         * form data converted from the keyed data\n         *\n         * @param index - The index at which the add button is clicked\n         */\n        this.onAddIndexClick = (index) => {\n            return (event) => {\n                this._handleAddClick(event, index);\n            };\n        };\n        /** Callback handler for when the user clicks on the copy button on an existing array element. Clones the row of\n         * keyed form data at the `index` into the next position in the state, and then returning `onChange()` with the plain\n         * form data converted from the keyed data\n         *\n         * @param index - The index at which the copy button is clicked\n         */\n        this.onCopyIndexClick = (index) => {\n            return (event) => {\n                if (event) {\n                    event.preventDefault();\n                }\n                const { onChange } = this.props;\n                const { keyedFormData } = this.state;\n                const newKeyedFormDataRow = {\n                    key: generateRowId(),\n                    item: lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3___default()(keyedFormData[index].item),\n                };\n                const newKeyedFormData = [...keyedFormData];\n                if (index !== undefined) {\n                    newKeyedFormData.splice(index + 1, 0, newKeyedFormDataRow);\n                }\n                else {\n                    newKeyedFormData.push(newKeyedFormDataRow);\n                }\n                this.setState({\n                    keyedFormData: newKeyedFormData,\n                    updatedKeyedFormData: true,\n                }, () => onChange(keyedToPlainFormData(newKeyedFormData)));\n            };\n        };\n        /** Callback handler for when the user clicks on the remove button on an existing array element. Removes the row of\n         * keyed form data at the `index` in the state, and then returning `onChange()` with the plain form data converted\n         * from the keyed data\n         *\n         * @param index - The index at which the remove button is clicked\n         */\n        this.onDropIndexClick = (index) => {\n            return (event) => {\n                if (event) {\n                    event.preventDefault();\n                }\n                const { onChange, errorSchema } = this.props;\n                const { keyedFormData } = this.state;\n                // refs #195: revalidate to ensure properly reindexing errors\n                let newErrorSchema;\n                if (errorSchema) {\n                    newErrorSchema = {};\n                    for (const idx in errorSchema) {\n                        const i = parseInt(idx);\n                        if (i < index) {\n                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i], errorSchema[idx]);\n                        }\n                        else if (i > index) {\n                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i - 1], errorSchema[idx]);\n                        }\n                    }\n                }\n                const newKeyedFormData = keyedFormData.filter((_, i) => i !== index);\n                this.setState({\n                    keyedFormData: newKeyedFormData,\n                    updatedKeyedFormData: true,\n                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));\n            };\n        };\n        /** Callback handler for when the user clicks on one of the move item buttons on an existing array element. Moves the\n         * row of keyed form data at the `index` to the `newIndex` in the state, and then returning `onChange()` with the\n         * plain form data converted from the keyed data\n         *\n         * @param index - The index of the item to move\n         * @param newIndex - The index to where the item is to be moved\n         */\n        this.onReorderClick = (index, newIndex) => {\n            return (event) => {\n                if (event) {\n                    event.preventDefault();\n                    event.currentTarget.blur();\n                }\n                const { onChange, errorSchema } = this.props;\n                let newErrorSchema;\n                if (errorSchema) {\n                    newErrorSchema = {};\n                    for (const idx in errorSchema) {\n                        const i = parseInt(idx);\n                        if (i == index) {\n                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [newIndex], errorSchema[index]);\n                        }\n                        else if (i == newIndex) {\n                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [index], errorSchema[newIndex]);\n                        }\n                        else {\n                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [idx], errorSchema[i]);\n                        }\n                    }\n                }\n                const { keyedFormData } = this.state;\n                function reOrderArray() {\n                    // Copy item\n                    const _newKeyedFormData = keyedFormData.slice();\n                    // Moves item from index to newIndex\n                    _newKeyedFormData.splice(index, 1);\n                    _newKeyedFormData.splice(newIndex, 0, keyedFormData[index]);\n                    return _newKeyedFormData;\n                }\n                const newKeyedFormData = reOrderArray();\n                this.setState({\n                    keyedFormData: newKeyedFormData,\n                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));\n            };\n        };\n        /** Callback handler used to deal with changing the value of the data in the array at the `index`. Calls the\n         * `onChange` callback with the updated form data\n         *\n         * @param index - The index of the item being changed\n         */\n        this.onChangeForIndex = (index) => {\n            return (value, newErrorSchema, id) => {\n                const { formData, onChange, errorSchema } = this.props;\n                const arrayData = Array.isArray(formData) ? formData : [];\n                const newFormData = arrayData.map((item, i) => {\n                    // We need to treat undefined items as nulls to have validation.\n                    // See https://github.com/tdegrunt/jsonschema/issues/206\n                    const jsonValue = typeof value === 'undefined' ? null : value;\n                    return index === i ? jsonValue : item;\n                });\n                onChange(newFormData, errorSchema &&\n                    errorSchema && Object.assign(Object.assign({}, errorSchema), { [index]: newErrorSchema }), id);\n            };\n        };\n        /** Callback handler used to change the value for a checkbox */\n        this.onSelectChange = (value) => {\n            const { onChange, idSchema } = this.props;\n            onChange(value, undefined, idSchema && idSchema.$id);\n        };\n        const { formData = [] } = props;\n        const keyedFormData = generateKeyedFormData(formData);\n        this.state = {\n            keyedFormData,\n            updatedKeyedFormData: false,\n        };\n    }\n    /** React lifecycle method that is called when the props are about to change allowing the state to be updated. It\n     * regenerates the keyed form data and returns it\n     *\n     * @param nextProps - The next set of props data\n     * @param prevState - The previous set of state data\n     */\n    static getDerivedStateFromProps(nextProps, prevState) {\n        // Don't call getDerivedStateFromProps if keyed formdata was just updated.\n        if (prevState.updatedKeyedFormData) {\n            return {\n                updatedKeyedFormData: false,\n            };\n        }\n        const nextFormData = Array.isArray(nextProps.formData) ? nextProps.formData : [];\n        const previousKeyedFormData = prevState.keyedFormData || [];\n        const newKeyedFormData = nextFormData.length === previousKeyedFormData.length\n            ? previousKeyedFormData.map((previousKeyedFormDatum, index) => {\n                return {\n                    key: previousKeyedFormDatum.key,\n                    item: nextFormData[index],\n                };\n            })\n            : generateKeyedFormData(nextFormData);\n        return {\n            keyedFormData: newKeyedFormData,\n        };\n    }\n    /** Returns the appropriate title for an item by getting first the title from the schema.items, then falling back to\n     * the description from the schema.items, and finally the string \"Item\"\n     */\n    get itemTitle() {\n        const { schema, registry } = this.props;\n        const { translateString } = registry;\n        return lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY, 'title'], lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY, 'description'], translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.ArrayItemTitle)));\n    }\n    /** Determines whether the item described in the schema is always required, which is determined by whether any item\n     * may be null.\n     *\n     * @param itemSchema - The schema for the item\n     * @return - True if the item schema type does not contain the \"null\" type\n     */\n    isItemRequired(itemSchema) {\n        if (Array.isArray(itemSchema.type)) {\n            // While we don't yet support composite/nullable jsonschema types, it's\n            // future-proof to check for requirement against these.\n            return !itemSchema.type.includes('null');\n        }\n        // All non-null array item types are inherently required by design\n        return itemSchema.type !== 'null';\n    }\n    /** Determines whether more items can be added to the array. If the uiSchema indicates the array doesn't allow adding\n     * then false is returned. Otherwise, if the schema indicates that there are a maximum number of items and the\n     * `formData` matches that value, then false is returned, otherwise true is returned.\n     *\n     * @param formItems - The list of items in the form\n     * @returns - True if the item is addable otherwise false\n     */\n    canAddItem(formItems) {\n        const { schema, uiSchema, registry } = this.props;\n        let { addable } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, registry.globalUiOptions);\n        if (addable !== false) {\n            // if ui:options.addable was not explicitly set to false, we can add\n            // another item if we have not exceeded maxItems yet\n            if (schema.maxItems !== undefined) {\n                addable = formItems.length < schema.maxItems;\n            }\n            else {\n                addable = true;\n            }\n        }\n        return addable;\n    }\n    /** Callback handler for when the user clicks on the add or add at index buttons. Creates a new row of keyed form data\n     * either at the end of the list (when index is not specified) or inserted at the `index` when it is, adding it into\n     * the state, and then returning `onChange()` with the plain form data converted from the keyed data\n     *\n     * @param event - The event for the click\n     * @param [index] - The optional index at which to add the new data\n     */\n    _handleAddClick(event, index) {\n        if (event) {\n            event.preventDefault();\n        }\n        const { onChange } = this.props;\n        const { keyedFormData } = this.state;\n        const newKeyedFormDataRow = {\n            key: generateRowId(),\n            item: this._getNewFormDataRow(),\n        };\n        const newKeyedFormData = [...keyedFormData];\n        if (index !== undefined) {\n            newKeyedFormData.splice(index, 0, newKeyedFormDataRow);\n        }\n        else {\n            newKeyedFormData.push(newKeyedFormDataRow);\n        }\n        this.setState({\n            keyedFormData: newKeyedFormData,\n            updatedKeyedFormData: true,\n        }, () => onChange(keyedToPlainFormData(newKeyedFormData)));\n    }\n    /** Renders the `ArrayField` depending on the specific needs of the schema and uischema elements\n     */\n    render() {\n        const { schema, uiSchema, idSchema, registry } = this.props;\n        const { schemaUtils, translateString } = registry;\n        if (!(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY in schema)) {\n            const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);\n            const UnsupportedFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('UnsupportedFieldTemplate', registry, uiOptions);\n            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnsupportedFieldTemplate, { schema: schema, idSchema: idSchema, reason: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.MissingItems), registry: registry }));\n        }\n        if (schemaUtils.isMultiSelect(schema)) {\n            // If array has enum or uniqueItems set to true, call renderMultiSelect() to render the default multiselect widget or a custom widget, if specified.\n            return this.renderMultiSelect();\n        }\n        if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isCustomWidget)(uiSchema)) {\n            return this.renderCustomWidget();\n        }\n        if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isFixedItems)(schema)) {\n            return this.renderFixedArray();\n        }\n        if (schemaUtils.isFilesArray(schema, uiSchema)) {\n            return this.renderFiles();\n        }\n        return this.renderNormalArray();\n    }\n    /** Renders a normal array without any limitations of length\n     */\n    renderNormalArray() {\n        const { schema, uiSchema = {}, errorSchema, idSchema, name, disabled = false, readonly = false, autofocus = false, required = false, registry, onBlur, onFocus, idPrefix, idSeparator = '_', rawErrors, } = this.props;\n        const { keyedFormData } = this.state;\n        const title = schema.title === undefined ? name : schema.title;\n        const { schemaUtils, formContext } = registry;\n        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);\n        const _schemaItems = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.items) ? schema.items : {};\n        const itemsSchema = schemaUtils.retrieveSchema(_schemaItems);\n        const formData = keyedToPlainFormData(this.state.keyedFormData);\n        const canAdd = this.canAddItem(formData);\n        const arrayProps = {\n            canAdd,\n            items: keyedFormData.map((keyedItem, index) => {\n                const { key, item } = keyedItem;\n                // While we are actually dealing with a single item of type T, the types require a T[], so cast\n                const itemCast = item;\n                const itemSchema = schemaUtils.retrieveSchema(_schemaItems, itemCast);\n                const itemErrorSchema = errorSchema ? errorSchema[index] : undefined;\n                const itemIdPrefix = idSchema.$id + idSeparator + index;\n                const itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);\n                return this.renderArrayFieldItem({\n                    key,\n                    index,\n                    name: name && `${name}-${index}`,\n                    canAdd,\n                    canMoveUp: index > 0,\n                    canMoveDown: index < formData.length - 1,\n                    itemSchema,\n                    itemIdSchema,\n                    itemErrorSchema,\n                    itemData: itemCast,\n                    itemUiSchema: uiSchema.items,\n                    autofocus: autofocus && index === 0,\n                    onBlur,\n                    onFocus,\n                    rawErrors,\n                    totalItems: keyedFormData.length,\n                });\n            }),\n            className: `field field-array field-array-of-${itemsSchema.type}`,\n            disabled,\n            idSchema,\n            uiSchema,\n            onAddClick: this.onAddClick,\n            readonly,\n            required,\n            schema,\n            title,\n            formContext,\n            formData,\n            rawErrors,\n            registry,\n        };\n        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ArrayFieldTemplate', registry, uiOptions);\n        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, Object.assign({}, arrayProps));\n    }\n    /** Renders an array using the custom widget provided by the user in the `uiSchema`\n     */\n    renderCustomWidget() {\n        var _a;\n        const { schema, idSchema, uiSchema, disabled = false, readonly = false, autofocus = false, required = false, hideError, placeholder, onBlur, onFocus, formData: items = [], registry, rawErrors, name, } = this.props;\n        const { widgets, formContext, globalUiOptions, schemaUtils } = registry;\n        const _b = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions), { widget, title: uiTitle } = _b, options = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__rest)(_b, [\"widget\", \"title\"]);\n        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);\n        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;\n        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);\n        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, options: options, schema: schema, uiSchema: uiSchema, registry: registry, value: items, disabled: disabled, readonly: readonly, hideError: hideError, required: required, label: label, hideLabel: !displayLabel, placeholder: placeholder, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));\n    }\n    /** Renders an array as a set of checkboxes\n     */\n    renderMultiSelect() {\n        var _a;\n        const { schema, idSchema, uiSchema, formData: items = [], disabled = false, readonly = false, autofocus = false, required = false, placeholder, onBlur, onFocus, registry, rawErrors, name, } = this.props;\n        const { widgets, schemaUtils, formContext, globalUiOptions } = registry;\n        const itemsSchema = schemaUtils.retrieveSchema(schema.items, items);\n        const enumOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.optionsList)(itemsSchema);\n        const _b = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions), { widget = 'select', title: uiTitle } = _b, options = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__rest)(_b, [\"widget\", \"title\"]);\n        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);\n        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;\n        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);\n        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, options: Object.assign(Object.assign({}, options), { enumOptions }), schema: schema, uiSchema: uiSchema, registry: registry, value: items, disabled: disabled, readonly: readonly, required: required, label: label, hideLabel: !displayLabel, placeholder: placeholder, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));\n    }\n    /** Renders an array of files using the `FileWidget`\n     */\n    renderFiles() {\n        var _a;\n        const { schema, uiSchema, idSchema, name, disabled = false, readonly = false, autofocus = false, required = false, onBlur, onFocus, registry, formData: items = [], rawErrors, } = this.props;\n        const { widgets, formContext, globalUiOptions, schemaUtils } = registry;\n        const _b = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions), { widget = 'files', title: uiTitle } = _b, options = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__rest)(_b, [\"widget\", \"title\"]);\n        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);\n        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;\n        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);\n        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { options: options, id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, schema: schema, uiSchema: uiSchema, value: items, disabled: disabled, readonly: readonly, required: required, registry: registry, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors, label: label, hideLabel: !displayLabel }));\n    }\n    /** Renders an array that has a maximum limit of items\n     */\n    renderFixedArray() {\n        const { schema, uiSchema = {}, formData = [], errorSchema, idPrefix, idSeparator = '_', idSchema, name, disabled = false, readonly = false, autofocus = false, required = false, registry, onBlur, onFocus, rawErrors, } = this.props;\n        const { keyedFormData } = this.state;\n        let { formData: items = [] } = this.props;\n        const title = schema.title || name;\n        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);\n        const { schemaUtils, formContext } = registry;\n        const _schemaItems = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.items) ? schema.items : [];\n        const itemSchemas = _schemaItems.map((item, index) => schemaUtils.retrieveSchema(item, formData[index]));\n        const additionalSchema = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalItems)\n            ? schemaUtils.retrieveSchema(schema.additionalItems, formData)\n            : null;\n        if (!items || items.length < itemSchemas.length) {\n            // to make sure at least all fixed items are generated\n            items = items || [];\n            items = items.concat(new Array(itemSchemas.length - items.length));\n        }\n        // These are the props passed into the render function\n        const canAdd = this.canAddItem(items) && !!additionalSchema;\n        const arrayProps = {\n            canAdd,\n            className: 'field field-array field-array-fixed-items',\n            disabled,\n            idSchema,\n            formData,\n            items: keyedFormData.map((keyedItem, index) => {\n                const { key, item } = keyedItem;\n                // While we are actually dealing with a single item of type T, the types require a T[], so cast\n                const itemCast = item;\n                const additional = index >= itemSchemas.length;\n                const itemSchema = additional && lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalItems)\n                    ? schemaUtils.retrieveSchema(schema.additionalItems, itemCast)\n                    : itemSchemas[index];\n                const itemIdPrefix = idSchema.$id + idSeparator + index;\n                const itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);\n                const itemUiSchema = additional\n                    ? uiSchema.additionalItems || {}\n                    : Array.isArray(uiSchema.items)\n                        ? uiSchema.items[index]\n                        : uiSchema.items || {};\n                const itemErrorSchema = errorSchema ? errorSchema[index] : undefined;\n                return this.renderArrayFieldItem({\n                    key,\n                    index,\n                    name: name && `${name}-${index}`,\n                    canAdd,\n                    canRemove: additional,\n                    canMoveUp: index >= itemSchemas.length + 1,\n                    canMoveDown: additional && index < items.length - 1,\n                    itemSchema,\n                    itemData: itemCast,\n                    itemUiSchema,\n                    itemIdSchema,\n                    itemErrorSchema,\n                    autofocus: autofocus && index === 0,\n                    onBlur,\n                    onFocus,\n                    rawErrors,\n                    totalItems: keyedFormData.length,\n                });\n            }),\n            onAddClick: this.onAddClick,\n            readonly,\n            required,\n            registry,\n            schema,\n            uiSchema,\n            title,\n            formContext,\n            rawErrors,\n        };\n        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ArrayFieldTemplate', registry, uiOptions);\n        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, Object.assign({}, arrayProps));\n    }\n    /** Renders the individual array item using a `SchemaField` along with the additional properties required to be send\n     * back to the `ArrayFieldItemTemplate`.\n     *\n     * @param props - The props for the individual array item to be rendered\n     */\n    renderArrayFieldItem(props) {\n        const { key, index, name, canAdd, canRemove = true, canMoveUp, canMoveDown, itemSchema, itemData, itemUiSchema, itemIdSchema, itemErrorSchema, autofocus, onBlur, onFocus, rawErrors, totalItems, } = props;\n        const { disabled, hideError, idPrefix, idSeparator, readonly, uiSchema, registry, formContext } = this.props;\n        const { fields: { ArraySchemaField, SchemaField }, globalUiOptions, } = registry;\n        const ItemSchemaField = ArraySchemaField || SchemaField;\n        const { orderable = true, removable = true, copyable = false } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);\n        const has = {\n            moveUp: orderable && canMoveUp,\n            moveDown: orderable && canMoveDown,\n            copy: copyable && canAdd,\n            remove: removable && canRemove,\n            toolbar: false,\n        };\n        has.toolbar = Object.keys(has).some((key) => has[key]);\n        return {\n            children: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ItemSchemaField, { name: name, index: index, schema: itemSchema, uiSchema: itemUiSchema, formData: itemData, formContext: formContext, errorSchema: itemErrorSchema, idPrefix: idPrefix, idSeparator: idSeparator, idSchema: itemIdSchema, required: this.isItemRequired(itemSchema), onChange: this.onChangeForIndex(index), onBlur: onBlur, onFocus: onFocus, registry: registry, disabled: disabled, readonly: readonly, hideError: hideError, autofocus: autofocus, rawErrors: rawErrors })),\n            className: 'array-item',\n            disabled,\n            canAdd,\n            hasCopy: has.copy,\n            hasToolbar: has.toolbar,\n            hasMoveUp: has.moveUp,\n            hasMoveDown: has.moveDown,\n            hasRemove: has.remove,\n            index,\n            totalItems,\n            key,\n            onAddIndexClick: this.onAddIndexClick,\n            onCopyIndexClick: this.onCopyIndexClick,\n            onDropIndexClick: this.onDropIndexClick,\n            onReorderClick: this.onReorderClick,\n            readonly,\n            registry,\n            schema: itemSchema,\n            uiSchema: itemUiSchema,\n        };\n    }\n}\n/** `ArrayField` is `React.ComponentType<FieldProps<T[], S, F>>` (necessarily) but the `registry` requires things to be a\n * `Field` which is defined as `React.ComponentType<FieldProps<T, S, F>>`, so cast it to make `registry` happy.\n */\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ArrayField);\n//# sourceMappingURL=ArrayField.js.map\n\n//# sourceURL=webpack://woocommerce-rtm-custom-emails/./node_modules/@rjsf/core/lib/components/fields/ArrayField.js?");

/***/ })

}]);