<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * This is sort of legacy, so we won't put any effort in this mapping
 *
 * WpLinks
 */
#[ORM\Table('links')]
#[ORM\Index(['link_visible'], name: 'link_visible')]
#[ORM\Entity]
class Links
{
    /**
     * @var int
     */
    #[ORM\Column(name: 'link_id', type: \Doctrine\DBAL\Types\Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?string $linkId = null;

    #[ORM\Column(name: 'link_url', type: \Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkUrl = '';

    #[ORM\Column(name: 'link_name', type: \Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkName = '';

    #[ORM\Column(name: 'link_image', type: \Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkImage = '';

    #[ORM\Column(name: 'link_target', type: \Doctrine\DBAL\Types\Types::STRING, length: 25)]
    private string $linkTarget = '';

    #[ORM\Column(name: 'link_description', type: \Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkDescription = '';

    #[ORM\Column(name: 'link_visible', type: \Doctrine\DBAL\Types\Types::STRING, length: 20, options: ['default' => 'Y'])]
    private string $linkVisible = 'Y';

    #[ORM\Column(name: 'link_owner', type: \Doctrine\DBAL\Types\Types::BIGINT, options: ['default' => 1, 'unsigned' => true])]
    private string $linkOwner = '1';

    #[ORM\Column(name: 'link_rating', type: \Doctrine\DBAL\Types\Types::INTEGER)]
    private string $linkRating = '0';

    /**
     * @var \DateTimeInterface
     */
    #[ORM\Column(name: 'link_updated', type: \Doctrine\DBAL\Types\Types::DATETIME_MUTABLE, options: ['default' => '0000-00-00 00:00:00'])]
    private string $linkUpdated = '0000-00-00 00:00:00';

    #[ORM\Column(name: 'link_rel', type: \Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkRel = '';

    /**
     * @var string
     */
    #[ORM\Column(name: 'link_notes', type: \Doctrine\DBAL\Types\Types::TEXT, length: 16_777_215)]
    private ?string $linkNotes = null;

    #[ORM\Column(name: 'link_rss', type: \Doctrine\DBAL\Types\Types::STRING, length: 255)]
    private string $linkRss = '';


}
