<?php

namespace RTMMailComposer\ContextBuilder;

use RTMMailComposer\Model\CustomMail;

/**
 * @template T The object class
 */
abstract class ObjectContextBuilder implements ContextBuilderInterface
{

    public function __construct(public string $objectType)
    {
    }

    /**
     * @inheritDoc
     * @param T $mailObject
     */
    abstract public function prepareContext(CustomMail $mail, object $mailObject, array $context = []): array;
}
