<?php

namespace WordpressModels\Rest\Permissions;

use Symfony\Component\ExpressionLanguage\ExpressionFunction;
use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class RoleExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    private PermissionFunctionsInterface $permissionFunctions;

    public function __construct(PermissionFunctionsInterface $functions)
    {
        $this->permissionFunctions = $functions;
    }

    public function compile(string $value)
    {
        $class = $this->permissionFunctions::class;
        return "$class::userHasRole('$value')";
    }

    public function evaluate($args, $role)
    {
        return $this->permissionFunctions::userHasRole($role);
    }

    public function getFunctions()
    {
        return [
            new ExpressionFunction('role', $this->compile(...), $this->evaluate(...)),
        ];
    }
}