<?php

namespace WordpressModels\Rest\Permissions;

/**
 * Invokable class for processing permission expressions.
 * Should be hooked directly in the `permission_callback` argument for a `register_rest_route()` call
 */
class RequestPermissionEvaluator
{

    public function __construct(private readonly string $permissionExpression)
    {
    }

    public function __invoke(\WP_REST_Request $request)
    {
        try {
            return PermissionExpressionLanguage::instance()
                ->getLanguage()
                ->evaluate($this->permissionExpression, $request->get_params());
        } catch (\Throwable) {
            return false;
        }
    }

}
