<?php

namespace WordpressModels\Rest\Permissions;

use Symfony\Component\ExpressionLanguage\ExpressionLanguage;
use WordpressModels\Traits\SingletonTrait;

class PermissionExpressionLanguage
{

    use SingletonTrait;

    private ExpressionLanguage $language;

    public function __construct(
        private readonly PermissionFunctionsInterface $permissionFunctions = new WordpressPermissionFunctions()
    )
    {
        $this->language = new ExpressionLanguage(null,
            [
            new RoleExpressionFunctionProvider($permissionFunctions),
            new AuthorizationExpressionFunctionProvider($permissionFunctions),
            new CapabilityExpressionFunctionProvider($permissionFunctions)
        ]);
    }

    public function evaluate(string $expression, array $routeParams)
    {
        return $this->language->evaluate($expression, $routeParams);
    }

    /**
     * @return ExpressionLanguage
     */
    public function getLanguage(): ExpressionLanguage
    {
        return $this->language;
    }

}