<?php

namespace WordpressModels\Rest\Permissions;

use Symfony\Component\ExpressionLanguage\ExpressionFunction;
use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class CapabilityExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    private PermissionFunctionsInterface $permissionFunctions;

    public function __construct(PermissionFunctionsInterface $permissionFunctions)
    {
        $this->permissionFunctions = $permissionFunctions;
    }

    public function compile(string $value)
    {
        $class = $this->permissionFunctions::class;
        return "$class::userHasCapability('$value')";
    }

    public function evaluate($args, string $capability)
    {
        return $this->permissionFunctions::userHasCapability($capability);
    }

    public function getFunctions()
    {
        return [
            new ExpressionFunction('capability', $this->compile(...), $this->evaluate(...)),
        ];
    }
}