<?php

namespace WordpressModels\Rest\Permissions;

use Symfony\Component\ExpressionLanguage\ExpressionFunction;
use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class AuthorizationExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    private PermissionFunctionsInterface $permissionFunctions;

    public function __construct(PermissionFunctionsInterface $permissionFunctions)
    {
        $this->permissionFunctions = $permissionFunctions;
    }

    public function compileIsLoggedIn()
    {
        $class = $this->permissionFunctions::class;
        return "$class::isAuthorized()";
    }

    public function evaluateisLoggedIn()
    {
        return $this->permissionFunctions::isAuthorized();
    }

    public function getFunctions()
    {
        return [
            new ExpressionFunction('is_authorized',
                $this->compileIsLoggedIn(...),
                $this->evaluateisLoggedIn(...)),
        ];
    }
}