<?php

namespace RTMCustomMails\Renderer;

use RTMCustomMails\ConditionProcessor\OrderFunctionProvider;
use RTMCustomMails\ContextBuilder\WPContextBuilder;
use RTMMailComposer\Model\EmailSection;
use RTMMailComposer\Renderer\TwigEmailRenderer;
use Timber\Loader;
use WordpressModels\Traits\SingletonTrait;

class TimberEmailRenderer extends TwigEmailRenderer
{

    use SingletonTrait;

    protected function __construct()
    {
        parent::__construct(new WPContextBuilder(), ( new Loader() )->get_twig());

        add_action('wrce_email_sections', [ $this, 'render' ], 10, 2);

        add_action('wrce_render_email_section', [ $this, 'renderSection' ], 10, 3);


        $this->conditionProcessor->registerFunctionProvider(new OrderFunctionProvider());
    }


    /**
     * @inheritDoc
     */
    public function renderSection(EmailSection $section, array $context): string
    {
        [ $action, $action_arguments ] = apply_filters('wrce_email_section_action', $section->getId(), $context);

        // set default args for default hook
        if ($action === 'wrce_render_email_section') {
            $renderedSection = parent::renderSection($section, $context);
        } else {
            ob_start();
            do_action($action, ...$action_arguments);
            $renderedSection = ob_get_clean();
        }
        return  $renderedSection;
    }
}
