<?php

namespace RTMCustomMails\Preview\ObjectSupport;

use WordpressModels\Traits\AbstractSingletonTrait;

abstract class EmailObjectSupport implements EmailObjectSupportInterface
{

    use AbstractSingletonTrait;

    public function __construct(
        protected string $objectType,
        protected bool   $isAttachmentAllowed = false
    )
    {
        add_filter('wrce_preview_object_selector_types', [$this, 'addAllowedObjectType']);
        add_filter('wrce_preview_object_selector_config', [$this, 'addSelectorSupport']);

        add_filter("wrce_preview_find_objects_$this->objectType", [$this, 'findObjects'], 10, 2);

        add_filter("wrce_email_allowed_variables/object_type=$this->objectType", [$this, 'getAllowedContextVariables']);
        add_filter("wrce_email_trigger_hook_options/object_type=$this->objectType", [$this, 'addTriggerHookOptions']);


        if ($isAttachmentAllowed) {
            add_filter('wrce_allowed_attachment_object_types', [$this, 'addAllowedObjectType']);
        }
    }

    /**
     * @return string
     */
    public function getObjectType(): string
    {
        return $this->objectType;
    }

    public function addAllowedObjectType(array $types): array
    {
        $types[] = $this->objectType;
        return $types;
    }

    public function addSelectorSupport(array $config): array
    {
        return $config + [$this->objectType => $this->getSelectorConfig()];
    }

    protected abstract function getSelectorConfig(): array;

    public abstract function getAllowedContextVariables($vars = []): array;

    public abstract function findObjects(array $objects, string $search): array;

    /**
     * Used for presetting the options in the object selector.
     *
     * @param int $amount
     * @return array
     */
    public abstract function getLatestObjects(int $amount = 20): array;

    public abstract function addTriggerHookOptions(array $options = []): array;

}