<?php

namespace RTMCustomMails\Preview;

use RTMCustomMails\Preview\ObjectSupport\EmailObjectSupport;
use RTMCustomMails\Preview\ObjectSupport\EmailOrderSupport;
use RTMCustomMails\Preview\ObjectSupport\EmailUserSupport;
use WordpressModels\Traits\SingletonTrait;

class EmailObjects
{

    use SingletonTrait;

    public function __construct(private array $supported = [])
    {
        add_action('init', [$this, 'applyRegisteredObjectSupport']);

        add_filter('wrce_register_object_preview_support', [$this, 'addDefaultObjectSupport']);
    }

    public function addDefaultObjectSupport(array $supported): array
    {
        return array_reduce(
            [EmailOrderSupport::instance(), EmailUserSupport::instance()],
            function ($carry, EmailObjectSupport $support) {
                $carry[$support->getObjectType()] = $support;
                return $carry;
            },
            $supported
        );
    }

    public function applyRegisteredObjectSupport(): void
    {
        $this->supported = apply_filters('wrce_register_object_preview_support', ['order']);
    }

    /**
     * @return EmailObjectSupport[]
     */
    public function getSupported(): array
    {
        return $this->supported;
    }


}