<?php

namespace RTMCustomMails;

use RTMCustomMails\Email\RTMCustomEmail;
use WC_Email;
use WC_Emails;
use WordpressModels\Traits\SingletonTrait;

class EmailTriggerHooks
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('wrce_email_trigger_hooks', [$this, 'applyFilterHookOptionValue'], 10, 2);
        add_filter('woocommerce_email', [$this, 'addTriggerHookOption']);
    }

    /**
     * Add 'trigger_hooks' option to all available email types.
     *
     * @param WC_Emails $emails
     * @return void
     */
    public function addTriggerHookOption(WC_Emails $emails): void
    {
        $instances = $emails->get_emails();

        foreach ($instances as $instance) {
            $instance = RTMCustomEmail::asCustomEmail($instance);
            $defaultTriggers = $instance->getTriggerHooks();
            if (!$instance->get_option('trigger_hooks')) {
                $instance->update_option('trigger_hooks', $defaultTriggers);
            }

            $hooks = apply_filters('wrce_email_trigger_hook_options', [], $instance);
            $hooks = apply_filters('wrce_email_trigger_hook_options/email_id=' . $instance->id, $hooks, $instance);
            $hooks = apply_filters('wrce_email_trigger_hook_options/object_type=' . $instance->getObjectType(), $hooks, $instance);

            foreach ($hooks as $group => $array) {
                if (is_array($array)) {
                    continue;
                }

                // set the trigger to an empty named group.
                $hooks[''][$group] = $array;
                unset($hooks[$group]);
            }

            $instance->form_fields['trigger_hooks'] = [
                'title' => __('Trigger Hooks', 'wrce'),
                'description' => __('This email will sent when specific event(s) occurs.', 'wrce'),
                'type' => 'multiselect',
                'default' => apply_filters('wrce_email_trigger_hooks', $defaultTriggers, $instance),
                'options' => $hooks
            ];
        }
    }

    public function applyFilterHookOptionValue(array $hooks, WC_Email $email): array
    {
        return (array) $email->get_option('trigger_hooks', $hooks);
    }

}