<?php

namespace RTMCustomMails\EmailSections\Defaults;

use RTMMailComposer\Model\EmailSection;

class CustomerResetPasswordDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_reset_password';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections() : array
    {
        return [
            new EmailSection(
                'woocommerce_email_header',
                true,
                'Header',
                false,
                '',
                [],
                1,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                esc_html__('Hi {{ user_login }},', 'woocommerce'),
                [],
                2,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                <<<TWIG
Someone has requested a new password for the following account on {{ site_title }}:
Username: {{ user_login }}
If you didn't make this request, just ignore this email. If you'd like to proceed:
{{ link(woocommerce_lost_password_url, 'Click here to reset your password', ['link']) }}
TWIG,
                [],
                3,
            ),
            new EmailSection(
                'woocommerce_email_additional_content',
                true,
                'Additional Content',
                false,
                '',
                [],
                4,
            ),
            new EmailSection(
                'woocommerce_email_footer',
                true,
                'Footer',
                false,
                '',
                [],
                5,
            )
        ];
    }
}
