<?php

namespace RTMCustomMails\EmailSections\Defaults;

use RTMMailComposer\Model\EmailSection;

class CustomerRefundedOrderDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_refunded_order';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections() : array
    {
        return [
            new EmailSection(
                'woocommerce_email_header',
                true,
                'Header',
                false,
                '',
                [],
                1,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                esc_html__('Hi {{ billing_first_name }},', 'woocommerce'),
                [],
                2,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                <<<TWIG
{% if partial_refund %}
    Your order on {{ site_title }} has been partially refunded. There are more details below for your reference:
{% else %}
    Your order on {{ site_title }} has been refunded. There are more details below for your reference:
{% endif %}
TWIG,
                [],
                2,
            ),
            new EmailSection(
                'woocommerce_email_order_details',
                true,
                'Order Details',
                false,
                '',
                [],
                3,
            ),
            new EmailSection(
                'woocommerce_email_order_meta',
                true,
                'Order Meta',
                false,
                '',
                [],
                3,
            ),
            new EmailSection(
                'woocommerce_email_customer_details',
                true,
                'Customer Details',
                false,
                '',
                [],
                4,
            ),
            new EmailSection(
                'woocommerce_email_additional_content',
                true,
                'Additional Content',
                false,
                '',
                [],
                5,
            ),
            new EmailSection(
                'woocommerce_email_footer',
                true,
                'Footer',
                false,
                '',
                [],
                6,
            )
        ];
    }
}
