<?php

namespace RTMCustomMails\EmailSections\Defaults;

use RTMMailComposer\Model\EmailSection;

class CustomerNewAccountDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_new_account';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections() : array
    {
        return [
            new EmailSection(
                'woocommerce_email_header',
                true,
                'Header',
                false,
                '',
                [],
                1,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                esc_html__('Hi {{ user_login }},', 'woocommerce'),
                [],
                2,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                <<<TWIG
Thanks for creating an account on {{ site_title }}. Your username is {{ user_login }}. You can access your account area to view orders, change your password, and more at: {{ woocommerce_my_account_url }}.
{% if is_password_generated %}
    {{ link(set_password_url, 'Click here to set your new password.') }}
{% endif %}
TWIG,
                [],
                2,
            ),
            new EmailSection(
                'woocommerce_email_additional_content',
                true,
                'Additional Content',
                false,
                '',
                [],
                5,
            ),
            new EmailSection(
                'woocommerce_email_footer',
                true,
                'Footer',
                false,
                '',
                [],
                6,
            )
        ];
    }
}
