<?php

namespace RTMCustomMails\EmailSections\Defaults;

use RTMMailComposer\Model\EmailSection;

class CustomerInvoiceDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_invoice';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections() : array
    {
        return [
            new EmailSection(
                'woocommerce_email_header',
                true,
                'Header',
                false,
                '',
                [],
                1,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                esc_html__('Hi {{ billing_first_name }},', 'woocommerce'),
                [],
                2,
            ),
            new EmailSection(
                '',
                true,
                'Main Text',
                false,
                <<<TWIG
{% if (order_needs_payment) %}
    An order has been created for you on {{ site_title }}. Your invoice is below, with a link to make payment when you’re ready: {{ order_payment_link(order, 'Pay for this order') }}
{% else %}
    Here are the details of your order placed on {{ order_date }}:
{% endif %}
TWIG,
                [],
                2,
            ),
            new EmailSection(
                'woocommerce_email_order_details',
                true,
                'Order Details',
                false,
                '',
                [],
                3,
            ),
            new EmailSection(
                'woocommerce_email_order_meta',
                true,
                'Order Meta',
                false,
                '',
                [],
                3,
            ),
            new EmailSection(
                'woocommerce_email_customer_details',
                true,
                'Customer Details',
                false,
                '',
                [],
                4,
            ),
            new EmailSection(
                'woocommerce_email_additional_content',
                true,
                'Additional Content',
                false,
                '',
                [],
                5,
            ),
            new EmailSection(
                'woocommerce_email_footer',
                true,
                'Footer',
                false,
                '',
                [],
                6,
            )
        ];
    }
}
