<?php

namespace RTMCustomMails\ContextBuilder;

use RTMCustomMails\Email\RTMCustomEmail;
use RTMMailComposer\ContextBuilder\ContextBuilder;
use RTMMailComposer\ContextBuilder\ContextBuilderInterface;
use RTMMailComposer\Model\CustomMail;

class WPContextBuilder implements ContextBuilderInterface
{

    public function __construct(protected ContextBuilder $builder = new ContextBuilder())
    {
        add_filter('wrce_inject_context/recipient_type=customer', [self::class, 'injectNonAdminContext']);
        add_filter('wrce_inject_context/recipient_type=admin', [self::class, 'injectAdminContext']);

        $this->builder->registerObjectContextBuilder(new WCOrderContextBuilder('order'));
        $this->builder->registerObjectContextBuilder(new WPUserContextBuilder('user'));
    }


    /**
     * Generates the generic base context
     * @param array $baseContext The initial context
     * @param RTMCustomEmail $mail The mail to use for building base context
     *
     * @return array The initial context combined with the generated generic default context
     */
    public function defaultContext(array $baseContext, RTMCustomEmail $mail): array
    {
        return $baseContext + [
                $mail->getObjectType() => $mail->object,
                'email_heading' => $mail->get_heading(),
                'additional_content' => $mail->get_additional_content(),
                'sent_to_admin' => true,
                'plain_text' => false,
                'email' => $mail,
            ];
    }

    /**
     * @inheritDoc
     */
    public function prepareContext(CustomMail $mail, object $mailObject, array $context = []): array
    {
        //builds a default context with the heading and other variables
        if ($mail instanceof RTMCustomEmail) {
            $context = $this->defaultContext($context, $mail);
        }

        //inject object context
        $context = $this->builder->prepareContext($mail, $mailObject, $context);

        //inject recipient context
        $recipientType = $mail->getRecipientType();

        return apply_filters("wrce_inject_context/recipient_type={$recipientType}", $context, $mail);
    }


    /**
     * @param array $context
     * @return array
     */
    public static function injectAdminContext(array $context): array
    {
        $user = $context['user'] ?? get_user_by('email', get_option('admin_email'));
        $context['recipient_name'] = $user->first_name . ' ' . $user->last_name;
        return $context;
    }

    /**
     * @param array $context
     * @return array
     */
    public static function injectNonAdminContext(array $context): array
    {
        if (isset($context['order'])) {
            $context['recipient_name'] = $context['order']->get_billing_first_name();
        } else {
            $context['recipient_name'] ??= $context['user']?->first_name
                ?: $context['billing_first_name']
                    ?: $context['user_login']
                        ?: (get_bloginfo('name') . ' Customer');
        }
        return $context;
    }
}
