<?php

namespace RTMMailComposer\Sender;

use RTMMailComposer\Model\CustomMail;

interface EmailSenderInterface
{
    /**
     * @param $to string recipient
     * @param $subject string subject
     * @param $message string content
     * @param $headers string headers
     * @param $attachments array attached to the mail
     * @param CustomMail $mail The Woocommerce Mail to be used
     *
     * @return bool Whether the email was sent successfully
     */
    public function send(string $to, string $subject, string $message, string $headers, array $attachments, CustomMail $mail) : bool;
}
