<?php

namespace RTMMailComposer\ContextBuilder;

use RTMMailComposer\Model\CustomMail;

interface ContextBuilderInterface
{

    /**
     * Prepares the context for the rendering of the email
     *
     * @param CustomMail $mail
     * @param Object $mailObject The object to be used in preparing the context
     * @param array $context The initial context
     *
     * @return array The prepared context
     */
    public function prepareContext(CustomMail $mail, Object $mailObject, array $context = []): array;
}
