<?php

namespace RTMMailComposer\ContextBuilder;

use RTMMailComposer\Model\CustomMail;
use WordpressModels\Traits\SingletonTrait;

class ContextBuilder implements ContextBuilderInterface
{

    use SingletonTrait;

    private array $builders = [];


    /**
     * Register object builder to the current context builder
     * @param ObjectContextBuilder $builder
     *
     * @return void
     */
    public function registerObjectContextBuilder(ObjectContextBuilder $builder)
    {
        $this->builders[$builder->objectType] = $builder;
    }

    /**
     * @inheritDoc
     */
    public function prepareContext(CustomMail $mail, object $mailObject, array $context = []) : array
    {
        return $this->builders[$mail->getObjectType()]->prepareContext($mail, $mailObject, $context);
    }
}
