<?php

namespace RTMMailComposer\ConditionProcessor;

use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class ConditionProcessor implements ConditionProcessorInterface
{

    public function __construct(protected ConditionExpressionLanguage $language = new ConditionExpressionLanguage())
    {
    }

    /**
     * Registers a new function provider
     * @param ExpressionFunctionProviderInterface $fpi
     *
     * @return void
     */
    public function registerFunctionProvider(ExpressionFunctionProviderInterface $fpi)
    {
        $this->language->getLanguage()->registerProvider($fpi);
    }

    /**
     * @inheritDoc
     */
    public function process(string $expression, array $parameters) : bool
    {
        return $this->language->evaluate($expression, $parameters);
    }
}
