<?php

namespace RTMCustomMails\Preview;

use RTMCustomMails\Email\RTMCustomEmail;
use WC_Email;
use WC_Emails;
use WordpressModels\Traits\SingletonTrait;

/**
 *
 */
class PreviewEmails
{

    use SingletonTrait;

    /**
     * Return an instance of this class.
     *
     * @return object A single instance of this class.
     */
    private array $emails = [];
    private ?string $notice_message = null;
    private ?string $notice_class = null;

    public function __construct()
    {
        add_action('woocommerce_email', [$this, 'load'], 999, 1);
        add_filter('wrce_filter_allowed_preview_emails', [$this, 'getAllowedPreviewEmails']);

        EmailObjects::instance();
    }

    /**
     * @param $emails
     * @return mixed
     */
    public function getAllowedPreviewEmails($emails)
    {
        $disallowed_previews = apply_filters('wrce_disallow_preview_email_types', []);

        foreach ($disallowed_previews as $disallowed_preview) {
            if (isset($emails[$disallowed_preview])) {
                unset($emails[$disallowed_preview]);
            }
        }

        return $emails;
    }

    public function load(WC_Emails $emails)
    {
        $this->emails = apply_filters('wrce_filter_allowed_preview_emails', $emails->get_emails());
    }

    /**
     * @param $recipient
     * @return string
     */
    public static function noRecipient($recipient)
    {
        return '';
    }

    public function renderEmail(string $emailType, int $itemId, WC_Email $currentEmail): string
    {
        $this->setupEmailContext($emailType, $itemId, $currentEmail);

        return apply_filters('woocommerce_mail_content', $currentEmail->style_inline($currentEmail->get_content_html()));
    }

    /**
     * @param string $emailType
     * @param int $itemId
     * @param WC_Email $currentEmail
     * @return array
     */
    public static function setupEmailContext(string $emailType, int $itemId, WC_Email $currentEmail)
    {
        $triggerArgs = apply_filters('wrce_preview_trigger_args', false, $emailType, $itemId, $currentEmail);

        // disable recipient and allow resend new order email
        add_filter('woocommerce_email_recipient_' . $currentEmail->id, [self::class, 'noRecipient']);
        add_filter('woocommerce_new_order_email_allows_resend', '__return_true');

        if ($triggerArgs) {
            if (is_array($triggerArgs)) {
                if (!array_is_list($triggerArgs)) {
                    call_user_func_array([$currentEmail, 'trigger'], $triggerArgs);
                } else {
                    call_user_func([$currentEmail, 'trigger'], ...$triggerArgs);
                }
            } else {
                call_user_func([$currentEmail, 'trigger'], $triggerArgs);
            }
        } elseif (str_starts_with($emailType, 'WCS_Email')
            && class_exists('WC_Subscription')
            && is_subclass_of($currentEmail, 'WC_Email')
            && function_exists('wcs_get_subscriptions_for_order')) {
            /* Get the subscriptions for the selected order */
            $order_subscriptions = wcs_get_subscriptions_for_order($itemId);
            if (!empty($order_subscriptions) && $currentEmail->id != 'customer_payment_retry' && $currentEmail->id != 'payment_retry') {
                /* Pick the first one as an example */
                $subscription = array_pop($order_subscriptions);
                $currentEmail->trigger($subscription);
            } else {
                $currentEmail->trigger($itemId, wc_get_order($itemId));
            }
        } else {
            $currentEmail->trigger($itemId);
        }

        // reenable recipient and allow resend new order email
        remove_filter('woocommerce_email_recipient_' . $currentEmail->id, [self::class, 'noRecipient']);
        remove_filter('woocommerce_new_order_email_allows_resend', '__return_true');

        if ($currentEmail instanceof RTMCustomEmail) {
            return $currentEmail->getRenderContext();
        } else {
            return [];
        }
    }

}