<?php

namespace RTMCustomMails;

use DateTime;
use WordpressModels\Meta;
use WordpressModels\PostMetaBox;

class OrderEmailLogMetaBox extends PostMetaBox
{

    public function __construct()
    {
        parent::__construct('wrce-order-email-log',
            'Email Log',
            'shop_order',
            'side',
            'low',
            ['bootstrap-util'],
            Core::instance()->assets()
        );
    }

    public function getEmailDateMeta(string $suffix, int $orderId)
    {
        $metas = Meta::getAllMetaKeysAndValuesLike("_wrce_%_$suffix", '', $orderId);
        $sentEmails = [];
        foreach ($metas as [$key, $value]) {
            $value = maybe_unserialize($value);

            $emailId = substr($key, 6, strlen($key) - strlen($suffix) - 7);
            if (is_array($value)) {
                $sentEmails[$emailId] = array_merge($sentEmails[$emailId] ?? [], array_map(fn($val) => new DateTime($val), $value));
            } else {
                $sentEmails[$emailId][] = new DateTime($value);
            }
        }
        return $sentEmails;
    }

    public function renderMetaBox(\WP_Post $post): void
    {
        $postId = $post->ID;
        $sentEmails = $this->getEmailDateMeta('sent', $postId);
        $failedEmails = $this->getEmailDateMeta('send_failure', $postId);

        if (!$sentEmails && !$failedEmails) {
            echo __("No logs found for this order", "wrce");
            return;
        }

        $emails = [];
        foreach ($sentEmails as $id => $dates) {
            $emails[$id] = array_map(fn($date) => [
                'color' => 'success',
                'type' => 'success',
                'date' => $date
            ], $dates);
        }
        foreach ($failedEmails as $id => $dates) {
            $emails[$id] = array_merge($emails[$id] ?? [], array_map(fn($date) => [
                'color' => 'danger',
                'type' => 'failure',
                'date' => $date
            ], $dates));
            usort($emails[$id], fn($d0, $d1) => $d0['date'] <=> $d1['date']);
        }

        foreach ($emails as $id => $dates) {
            $emailInstance = Util::getEmailById($id);
            if ($emailInstance) {
                $emailTitle = $emailInstance->get_title();
            } else {
                $emailTitle = $id;
            }
            echo "<div><strong>$emailTitle</strong><br/>";
            echo join(" ", array_map(fn(array $entry) => "<span class='badge text-bg-{$entry['color']}' title='{$entry['type']}'>{$entry['date']->format('Y-m-d H:i:s')}</span>", $dates));
            echo "</div>";
        }
    }

}