<?php

namespace RTMCustomMails\Email;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 *
 */
class RTMCustomEmail_Customer_Bank_Reminder extends RTMCustomEmail
{

    /**
     * Constructor.
     */
    public function __construct()
    {
        $this->id = 'customer_bank_reminder';
        $this->title = __('Bank reminder', 'woocommerce');
        $this->description = __('Bank reminder emails can be sent to customers containing their order information and a notification that they still have to pay', 'woocommerce');

        $this->template_base = untrailingslashit(WRCE_ROOT_PATH) . '/templates/';
        $this->template_html = '';
        $this->template_plain = '';

        $this->subject = __('Bank reminder', 'woocommerce');
        $this->heading = __('Bank reminder', 'woocommerce');


        // Call parent constructor
        parent::__construct();

        $this->customer_email = true;
    }

    /**
     * Trigger the sending of this email.
     *
     * @param int $order_id The order ID.
     */
    public function trigger($order_id = 0)
    {
        $this->object = $order = wc_get_order($order_id);

        if (is_a($order, 'WC_Order')) {
            $this->recipient = $this->object->get_billing_email();

            $this->placeholders['{order_date}'] = wc_format_datetime($this->object->get_date_created());
            $this->placeholders['{order_number}'] = $this->object->get_order_number();
        }

        if ($this->is_enabled() && $this->get_recipient()) {
            $this->send($this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments());
        }
    }

    /**
     * Get content plain.
     *
     * @access public
     * @return string
     */
    public function get_content_plain()
    {
        return wc_get_template_html($this->template_plain, [
            'order' => $this->object,
            'email_heading' => $this->get_heading(),
            'sent_to_admin' => false,
            'plain_text' => true,
            'email' => $this,
        ], '', $this->template_base);
    }

    /**
     * Initialise settings form fields.
     */
    public function init_form_fields()
    {
        $this->form_fields = [
            'enabled' => [
                'title' => __('Enable/Disable', 'woocommerce'),
                'type' => 'checkbox',
                'label' => __('Enable this email notification', 'woocommerce'),
                'default' => 'yes',
            ],
            'subject' => [
                'title' => __('Email subject', 'woocommerce'),
                'type' => 'text',
                /* translators: %s: default subject */
                'description' => sprintf(__('Defaults to %s', 'woocommerce'), '<code>' . $this->subject . '</code>'),
                'placeholder' => '',
                'default' => '',
                'desc_tip' => true,
            ],
            'heading' => [
                'title' => __('Email heading', 'woocommerce'),
                'type' => 'text',
                /* translators: %s: default heading */
                'description' => sprintf(__('Defaults to %s', 'woocommerce'), '<code>' . $this->heading . '</code>'),
                'placeholder' => '',
                'default' => '',
                'desc_tip' => true,
            ],
            'email_type' => [
                'title' => __('Email type', 'woocommerce'),
                'type' => 'select',
                'description' => __('Choose which format of email to send.', 'woocommerce'),
                'default' => 'html',
                'class' => 'email_type wc-enhanced-select',
                'options' => $this->get_email_type_options(),
                'desc_tip' => true,
            ],
        ];
    }

    public function getTriggerHooks(): array
    {
        return ['tt_send_bank_transfer_reminder'];
    }
}
