<?php

namespace WordpressModels\Rest;

use DateTime;
use Exception;

/**
 *
 */
class Validation
{

    public static function validateCurrentUserIsAdmin(): bool
    {
        return user_can(wp_get_current_user(), 'administrator');
    }

    /**
     * @return bool
     */
    public static function validatePublic()
    {
        return true;
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isNotNull($param)
    {
        return null !== $param;
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isNumericOrNull($param)
    {
        return null === $param || is_numeric($param);
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isArrayOrNull($param)
    {
        return null === $param || is_array($param);
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isObjectOrNull($param)
    {
        return null === $param || is_object($param);
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isFloatOrNull($param)
    {
        return null === $param || is_float($param);
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isIntOrNull($param)
    {
        return null === $param || is_float($param);
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isStringOrNull($param)
    {
        return null === $param || is_string($param);
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isBoolOrNull($param)
    {
        return null === $param || is_bool($param);
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isDateString($param)
    {
        try {
            new DateTime($param);
            return true;
        } catch (Exception $e) {
            // todo: log
            return false;
        }
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isArrayOfDates($param)
    {
        return !is_array($param) // not an array
            || !array_filter($param, fn($p) => $p && !self::isDateString($p));
    }

    /**
     * @param $param
     * @return bool
     */
    public static function isSortArguments($param)
    {
        return self::isAssociativeArray($param)
            && array_filter($param, fn($s) => in_array(strtoupper($param), ['DESC', 'ASC']));
    }

    /**
     * @param $filter
     * @return bool
     */
    public static function isAssociativeArray($filter): bool
    {
        return is_array($filter) && array_keys($filter) !== range(0, count($filter) - 1);
    }

}
