<?php

namespace WordpressModels\DataModels\Attribute;

use Attribute;

#[Attribute(Attribute::TARGET_METHOD)]
class Serialize
{

    private ?string $propertyName;
    private ?int $maxDepth;

    public function __construct(?string $propertyName = null, int $maxDepth = -1)
    {
        $this->propertyName = $propertyName;
        $this->maxDepth = $maxDepth;
    }

    /**
     * @return string|null
     */
    public function getPropertyName(): ?string
    {
        return $this->propertyName;
    }

    /**
     * @return int
     */
    public function getMaxDepth(): int
    {
        return $this->maxDepth;
    }

}
