<?php

namespace RTMCustomMails\Preview;

use WordpressModels\Traits\SingletonTrait;

/**
 *
 */
class PreviewTriggerArgs
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('wrce_preview_trigger_args_customer_note', [$this, 'getCustomerNoteArgs'], 10, 2);
        add_filter('wrce_preview_trigger_args_customer_new_account', [$this, 'getCustomerNewAccountArgs'], 10, 0);
    }

    /**
     * @param $default
     * @param $orderId
     * @return array[]
     */
    public function getCustomerNoteArgs($default, $orderId)
    {
        $customer_note = 'This is some customer note , just some dummy text nothing to see here';

        return [
            [
                'order_id' => $orderId,
                'customer_note' => $customer_note
            ]
        ];
    }

    /**
     * @return array
     */
    public function getCustomerNewAccountArgs()
    {
        return [get_current_user_id()];
    }

}