<?php
/**
 * Plugin Name: WooCommerce RTM Custom Emails
 * Description: Plugin to add any custom emails.
 * Author: RTM Business
 * Version: 0.0.7
 * Requires PHP: 8.0
 */

use RTMCustomMails\EmailSections\ActionSectionRender;
use RTMCustomMails\EmailSections\DefaultEmailSections;
use RTMCustomMails\EmailSections\EmailSections;
use RTMCustomMails\EmailSections\TwigContextInjection;
use RTMCustomMails\EmailSections\TwigFunctions;
use RTMCustomMails\EmailSections\TwigSectionRender;
use RTMCustomMails\OrderQuery;
use RTMCustomMails\Pages\EmailOverview;
use RTMCustomMails\Pages\ScheduledEmailsPage;
use RTMCustomMails\PDFInvoices\WoocommercePDFInvoices;
use RTMCustomMails\Preview\DisallowPreviews;
use RTMCustomMails\Preview\PreviewEmails;
use RTMCustomMails\Preview\PreviewTriggerArguments;
use RTMCustomMails\Rest\EmailApi;
use RTMCustomMails\Core;
use RTMCustomMails\Schedule\ScheduledEmails;
use RTMCustomMails\WoocommerceEmailActions;
use RTMCustomMails\WoocommerceEmailSettingsTable;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

define('WRCE_ROOT_PATH', plugin_dir_path(__FILE__));
define('WRCE_ROOT_URL', plugin_dir_url(__FILE__));

define('WRCE_ASSETS_PATH', plugin_dir_path(__FILE__) . 'assets');
define('WRCE_ASSETS_URL', plugin_dir_url(__FILE__) . 'assets');


if (!class_exists('RTMCustomMails\Core')) {
    require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';
}

Core::instance();

// Rest APIs (register rest_api_init in constructor)
EmailApi::instance();
WoocommercePDFInvoices::instance();
OrderQuery::instance();
PreviewEmails::instance();
PreviewTriggerArguments::instance();

add_action('init', function () {
    if (is_admin()) {
        // admin only modules
        DisallowPreviews::instance();

        EmailOverview::instance();
        ScheduledEmailsPage::instance();

        WoocommerceEmailSettingsTable::instance();
    }

    // register email sections taxonomy
    EmailSectionsTaxonomy::instance()->registerEmailSectionsTaxonomy();

    // dynamic email sections
    TwigContextInjection::instance();
    TwigFunctions::instance();
    TwigSectionRender::instance();
    ActionSectionRender::instance();
    DefaultEmailSections::instance();
    EmailSections::instance();

    // scheduling emails
    ScheduledEmails::instance();

    // woocommerce
    WoocommerceEmailActions::instance();
});
