<?php

namespace WordpressModels\Rest\Permissions;

class RolePermissionHandler extends AbstractPermissionHandler
{

    public function __construct()
    {
        parent::__construct('role');
    }

    /**
     * Validate the current user has one, one of more or all roles.
     *
     * Use `|` for or-wise checks, e.g. role:administrator|customer.
     * Use `&` for and-wise checks, e.g. role:administrator&customer.
     *
     * Use either of these checks, combinations are not supported.
     *
     * @param callable|null $callbackValue
     * @param string $value
     * @return callable|null
     */
    public function handle(?callable $callbackValue, $value): ?callable
    {
        $roles = explode('|', $value);
        if (count($roles) > 1) {
            // any given role
            return fn() => (bool) array_intersect($roles, wp_get_current_user()?->roles ?? []);
        }

        $roles = explode('&', $value);
        if (count($roles) > 1) {
            // all given roles
            return fn() => count(array_intersect($roles, wp_get_current_user()?->roles ?? [])) === count($roles);
        }

        return fn() => in_array($value, wp_get_current_user()?->roles ?? []);
    }
}