<?php

namespace WordpressModels\Rest\Permissions;

use Automattic\WooCommerce\Admin\API\Reports\Cache;

class PermissionHandlers
{

    /**
     * @var PermissionHandlerInterface[]
     */
    private array $permissionHandlers;

    public function __construct()
    {
        $this->permissionHandlers = [];

        add_action('rest_api_init', [$this, 'registerHandlers']);

        add_filter('rest_register_permission_handlers', [$this, 'registerDefaultPermissionHandlers']);
    }

    /**
     * @param PermissionHandlerInterface[] $handlers
     * @return PermissionHandlerInterface[]
     */
    public function registerDefaultPermissionHandlers(array $handlers = []): array
    {
        $handlers[] = new AuthPermissionHandler();
        $handlers[] = new RolePermissionHandler();
        $handlers[] = new CapabilityPermissionHandler();

        return $handlers;
    }

    public function registerHandlers()
    {
        $this->permissionHandlers = apply_filters('rest_register_permission_handlers', []);

        foreach ($this->permissionHandlers as $handler) {
            add_filter("rest_validate_callback_{$handler->getPrefix()}", [$handler, 'handle']);
        }
    }

}