<?php

namespace WordpressModels\Rest\Permissions;

class CapabilityPermissionHandler extends AbstractPermissionHandler
{

    public function __construct()
    {
        parent::__construct('capability');
    }

    /**
     * Validate the current user has one, one of more or all capabilities.
     *
     * Use `|` for or-wise checks, e.g. role:manage_post|manage_page.
     * Use `&` for and-wise checks, e.g. role:manage_post&manage_page.
     *
     * Use either of these checks, combinations are not supported.
     *
     * @param callable|null $callbackValue
     * @param $value
     * @return callable|null
     */
    public function handle(?callable $callbackValue, $value): ?callable
    {
        $capabilities = explode('|', $value);
        if (count($capabilities) > 1) {
            // any given role
            return fn() => array_reduce($capabilities, fn($carry, $cap) => $carry || current_user_can($cap), true);
        }

        $capabilities = explode('&', $value);
        if (count($capabilities) > 1) {
            // all given roles
            return fn() => array_reduce($capabilities, fn($carry, $cap) => $carry && current_user_can($cap), true);
        }

        return fn() => current_user_can($value);
    }
}