<?php

namespace WordpressModels\Rest\Permissions;

class AuthPermissionHandler extends AbstractPermissionHandler
{

    public function __construct()
    {
        parent::__construct('auth');
    }

    /**
     * @inheritDoc
     */
    public function handle(?callable $callbackValue, $value): ?callable
    {
        return match ($value) {
            'loggedIn' => fn() => is_user_logged_in(),
            'anonymous' => fn() => true,
            default => fn() => false
        };
    }
}