<?php

namespace WordpressModels\Rest\Attribute;

#[\Attribute(\Attribute::TARGET_METHOD | \Attribute::IS_REPEATABLE)]
class RestRoute
{
    const ARGUMENT_SHAPE = [
        'validate_callback' => 'callable',
        'sanitize_callback' => 'callable',
        'required' => 'bool',
        'default' => 'mixed',
        'type' => 'string'
    ];

    /**
     * @param string $route
     * @param array $methods
     * @param string|null $permission
     * @param array{self::ARGUMENT_SHAPE} $arguments
     * @param bool $override
     * @param bool $public
     */
    public function __construct(
        public readonly string  $route,
        public readonly array   $methods,
        public readonly ?string $permission = null,
        public readonly array   $arguments = [],
        public readonly bool    $override = false,
        public readonly bool    $public = true,
    )
    {
    }

}