<?php

namespace RTMCustomMails\Model;

use WordpressModels\DataModels\Model;

class EmailSection extends Model
{
    private string $id;
    private bool $enable;
    private string $title;
    private bool $showTitle;
    private string $text;
    private array $condition;
    private int $sortOrder;

    public function __construct(array $data = [])
    {
        $this->id = '';
        $this->enable = false;
        $this->title = '';
        $this->showTitle = false;
        $this->text = '';
        $this->condition = [];
        $this->sortOrder = 0;

        if ($data) {
            self::hydrate($this, $data);
        }
    }

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return EmailSection
     */
    public function setId(string $id): EmailSection
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return bool
     */
    public function isEnable(): bool
    {
        return $this->enable;
    }

    /**
     * @param bool $enable
     * @return EmailSection
     */
    public function setEnable(bool $enable): EmailSection
    {
        $this->enable = $enable;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return EmailSection
     */
    public function setTitle(string $title): EmailSection
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return bool
     */
    public function isShowTitle(): bool
    {
        return $this->showTitle;
    }

    /**
     * @param bool $showTitle
     * @return EmailSection
     */
    public function setShowTitle(?bool $showTitle): EmailSection
    {
        $this->showTitle = (bool) $showTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     * @return EmailSection
     */
    public function setText(string $text): EmailSection
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return array
     */
    public function getCondition(): array
    {
        return $this->condition;
    }

    /**
     * @param array $condition
     * @return EmailSection
     */
    public function setCondition(array $condition): EmailSection
    {
        $this->condition = $condition;
        return $this;
    }

    /**
     * @return int
     */
    public function getSortOrder(): int
    {
        return $this->sortOrder;
    }

    /**
     * @param int $sortOrder
     * @return EmailSection
     */
    public function setSortOrder(int $sortOrder): EmailSection
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

}