<?php

namespace RTMCustomMails\EmailSections;

use WC_Emails;
use WordpressModels\Traits\SingletonTrait;
use WP_Error;

/**
 *
 */
class DefaultEmailSections
{

    use SingletonTrait;

    private array $emails;

    private function __construct()
    {
        add_filter('woocommerce_emails', [$this, 'setEmails']);

        add_filter('wrce_default_email_sections', [$this, 'addWoocommerceHookSections']);
        add_filter('wrce_default_email_sections', [$this, 'addCommonSections']);
        add_filter('wrce_default_email_sections', [$this, 'addWoocommerceOrderEmailSections']);
        add_filter('wrce_default_email_sections', [$this, 'addWoocommerceCustomerEmailSections']);


        add_action('wp_ajax_wrce_email_section_add_defaults', [$this, 'ajaxAddDefaults']);
    }

    public function setEmails(WC_Emails $emails)
    {
        $this->emails = $emails->get_emails();
    }

    /**
     * @param $sections
     * @return array
     */
    public function addWoocommerceHookSections($sections)
    {
        $all_email_ids = array_map(fn($email) => $email->id, $this->emails);

        $woocommerceHooks = [
            [
                'id' => 'woocommerce_email_header',
                'title' => 'Woocommerce Default Email Header',
                'condition' => [],
                'enable' => true,
                'email_types' => $all_email_ids,
                'sort_order' => 0,
                'show_title' => false,
                'text' => ''
            ],
            [
                'id' => 'woocommerce_email_footer',
                'title' => 'Woocommerce Default Email Footer',
                'condition' => [],
                'enable' => true,
                'email_types' => $all_email_ids,
                'sort_order' => 1000,
                'show_title' => false,
                'text' => ''
            ],
            [
                'id' => 'woocommerce_email_order_details',
                'title' => 'Woocommerce Default Email Order Table',
                'condition' => [],
                'enable' => true,
                'email_types' => $order_email_ids,
                'sort_order' => 500,
                'show_title' => false,
                'text' => ''
            ],
            [
                'id' => 'woocommerce_email_order_meta',
                'title' => 'Woocommerce Default Email Order Meta',
                'condition' => [],
                'enable' => true,
                'email_types' => $order_email_ids,
                'sort_order' => 600,
                'show_title' => false,
                'text' => ''
            ],
            [
                'id' => 'woocommerce_email_customer_details',
                'title' => 'Woocommerce Default Email Customer Table',
                'condition' => [],
                'enable' => true,
                'email_types' => $order_email_ids,
                'sort_order' => 700,
                'show_title' => false,
                'text' => ''
            ]
        ];

        return array_merge($sections, $woocommerceHooks);
    }

    /**
     * @param $sections
     * @return array
     */
    public function addCommonSections($sections)
    {
        $all_email_ids = array_map(fn($email) => $email->id, $this->emails);
        $commonSections = [
            [
                'id' => 'greeting',
                'title' => 'Greeting',
                'condition' => [],
                'enable' => true,
                'email_types' => $all_email_ids,
                'sort_order' => 1,
                'show_title' => false,
                'text' => 'Hello {{ recipient_name }},'
            ],
            [
                'id' => 'signature',
                'title' => 'Signature',
                'condition' => [],
                'enable' => true,
                'email_types' => $all_email_ids,
                'sort_order' => 999,
                'show_title' => false,
                'text' => '{{ site.name }}'
            ]
        ];

        return array_merge($sections, $commonSections);
    }

    /**
     * @param $sections
     * @return array
     */
    public function addWoocommerceOrderEmailSections($sections)
    {
        $orderEmailSections = [
            [
                'id' => 'customer-new-order-text',
                'title' => 'Customer New Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_new_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => ''
            ],
            [
                'id' => 'customer-processing-order-text',
                'title' => 'Customer Processing Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_processing_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => 'Just to let you know &mdash; we\'ve received your order #{{ order_number }}, and it is now being processed: '
            ],
            [
                'id' => 'customer-on-hold-order-text',
                'title' => 'Customer On Hold Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_on_hold_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => 'We will process your order as soon as we have received the payment. Your order details are shown below for your reference:'
            ],
            [
                'id' => 'customer-refunded-order-text',
                'title' => 'Customer Refunded Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_refunded_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
{% if partial_refund %}
    Your order on {{ site.name }} has been partially refunded. There are more details below for your reference:
{% else %}
    Your order on {{ site.name }} has been refunded. There are more details below for your reference:
{% endif %}
TWIG
            ],
            [
                'id' => 'customer-invoice-text',
                'title' => 'Customer Invoice Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_invoice'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
{% if (order_needs_payment) %}
    An order has been created for you on {{ site.name }}. Your invoice is below, with a link to make payment when you’re ready: {{ order_payment_link(order, 'Pay for this order') }}
{% else %}
    Here are the details of your order placed on {{ order_date_created }}:
{% endif %}
TWIG
            ],
            [
                'id' => 'customer-completed-order-text',
                'title' => 'Customer Completed Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_completed_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
We have finished processing your order.
TWIG
            ],
            [
                'id' => 'admin-new-order-text',
                'title' => 'Admin New Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['new_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
You’ve received the following order from {{ order_formatted_billing_full_name }}:
TWIG
            ],
            [
                'id' => 'admin-failed-order-text',
                'title' => 'Admin Failed Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['failed_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
Payment for order #{{ order_number }} from {{ order_formatted_billing_full_name }} has failed. The order was as follows:
TWIG
            ],
            [
                'id' => 'admin-cancelled-order-text',
                'title' => 'Admin Cancelled Order Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['cancelled_order'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
Notification to let you know — order #{{ order_number }} belonging to {{ order_formatted_billing_full_name }} has been cancelled:
TWIG
            ]
        ];

        return array_merge($sections, $orderEmailSections);
    }

    /**
     * @param $sections
     * @return array
     */
    public function addWoocommerceCustomerEmailSections($sections)
    {
        $customerEmailSections = [
            [
                'id' => 'customer-reset-password-text',
                'title' => 'Customer Reset Password Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_reset_password'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
Someone has requested a new password for the following account on {{ site.name }}:
Username: {{ user_login }}
If you didn't make this request, just ignore this email. If you'd like to proceed:
{{ link(woocommerce_lost_password_url, 'Click here to reset your password', ['link']) }}
TWIG
            ],
            [
                'id' => 'customer-note-text',
                'title' => 'Customer Note Text',
                'email_types' => ['customer_note'],
                'enable' => true,
                'condition' => [],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
The following note has been added to your order:
<blockquote>{{ customer_note|wptexturize|wpautop }}</blockquote>
As a reminder, here are your order details:
TWIG
            ],
            [
                'id' => 'customer-new-account-text',
                'title' => 'Customer New Account Text',
                'condition' => [],
                'enable' => true,
                'email_types' => ['customer_new_account'],
                'sort_order' => 2,
                'show_title' => false,
                'text' => <<<TWIG
Thanks for creating an account on {{ site.name }}. Your username is {{ user_login }}. You can access your account area to view orders, change your password, and more at: {{ link(woocommerce_my_account_url) }}.
{% if is_password_generated %}
    {{ link(set_password_url, 'Click here to set your new password.') }}
{% endif %}
TWIG
            ]
        ];
        return array_merge($sections, $customerEmailSections);
    }

    public function generateAndAddDefaults()
    {
        $sections = apply_filters('wrce_default_email_sections', []);
        $default_fields = [
            'enable',
            'condition',
            'sort_order',
            'show_title',
            'text'
        ];
        $errors = [];

        foreach ($sections as $args) {
            $title = $args['title'];
            $result = wp_create_term($args['id'] ?? $title, EmailSectionsTaxonomy::TAXONOMY_IDENTIFIER);

            if (is_wp_error($result)) {
                $errors[] = $result;
                continue;
            }

            $term_id = $result['term_id'];
            wp_update_term($term_id, EmailSectionsTaxonomy::TAXONOMY_IDENTIFIER, [
                'name' => $title,
            ]);


            $term_selector = EmailSectionsTaxonomy::TAXONOMY_IDENTIFIER . '_' . $term_id;


            foreach ($default_fields as $key) {
                if (isset($args[$key])) {
                    update_field($key, $args[$key], $term_selector);
                }
            }
        }

        if (empty($errors)) {
            update_option('wrce_email_sections_defaults_added', 'true');
        }

        foreach ($errors as $error) {
            /** @var WP_Error $error */
            acf_add_admin_notice($error->get_error_message(), 'error');
        }
    }

    public function ajaxAddDefaults()
    {
        if (!wp_verify_nonce($_POST['_wpnonce'], 'wrce_email_section_add_defaults_action')) {
            wp_redirect($_POST['_wp_http_referer']);
            exit;
        }

        $this->generateAndAddDefaults();

        wp_redirect($_POST['_wp_http_referer']);
    }

}