<?php

if (WP_DEBUG) {
    ini_set('display_errors', 'On');
    error_reporting(-1);
}

if (!class_exists('WoocommerceJapak'))
{
    class WoocommerceJapak
    {
        /**
         * @var Japak_Communication
         */
        protected $japakCommunication;
        
        /**
         * @var bool
         */
        protected $stockInSync = false;

        /**
         * @var array
         */
        protected $options = array(
            'wcjpk_enabled' => array('label' => 'Ingeschakeld', 'type' => 'checkbox', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_application_name' => array('label' => 'Applicatie naam', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_application_id' => array('label' => 'Applicatie ID', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_security_code' => array('label' => 'Security code', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_webservice_url' => array('label' => 'Webservice URL', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_webshop_code' => array('label' => 'ShopCode', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_webshop_sku_prefix' => array('label' => 'Artikelnr. startnummer', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_brand' => array('label' => 'Merk', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_brand_group' => array('label' => 'Merk groep', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
        );

        public function __construct()
        {    
            // call init
            $this->init();
        }

        public function getJapakCommunication()
        {
            // Lazy loading
            if (!$this->japakCommunication) {
                $this->japakCommunication = new Japak_Communication(
                    get_option('wcjpk_application_name'),
                    get_option('wcjpk_application_id'),
                    get_option('wcjpk_security_code'),
                    get_option('wcjpk_webservice_url'),
                    get_option('wcjpk_webshop_code'),
                    get_option('wcjpk_webshop_sku_prefix')
                );
            }
            
            return $this->japakCommunication;
        }

        private function dump($input)
        {
            echo '<pre>' . print_r($input, true) . '</pre>';
        }

        public function isPaymentsEnabled()
        {
            return get_option('wcjpk_enable_payments') && intval(get_option('wcjpk_enable_payments')) == 1;
        }

        public function isEnabled()
        {
            return get_option('wcjpk_enabled') && intval(get_option('wcjpk_enabled')) == 1;
        }

        public function activation()
        {
            if (!wp_next_scheduled( 'wcjpk_cron_every_minut' )) {
                wp_schedule_event( time(), 'every_minut', 'wcjpk_cron_every_minut' );
            }
        }
        
        public function deactivation()
        {
	        wp_clear_scheduled_hook('wcjpk_cron_every_minut');
        }

        //Initializes WordPress hooks
        private function init()
        {
            // HOOKS ADMIN
            if (is_admin()) {
                add_action('admin_menu', array($this, 'initPlugin'));
                add_action('admin_init', array($this, 'registerSettings'));
                add_action('admin_menu', array($this, 'loadSettings'));
            }

            // HOOKS WOOCOMMERCE - ORDER Status
            add_action('woocommerce_order_status_processing', array($this, 'orderStatusChanged'));

            if ($this->isEnabled()) {
                if (isset($_GET['japak_test'])) {
	                add_action('woocommerce_after_register_post_type', array($this, 'syncStock'));
                }

                // Cronjob
                add_action('wcjpk_cron_every_minut', array($this, 'runCronMinutly'));
            }
        }
        
        public function japakTest()
        {	        
	        $orderData = get_post(1232);

            $order = wc_get_order($orderData->ID);
            $orderMeta = get_post_meta($orderData->ID);
            
            $japakOrder = new Japak_Objects_Order();

            // SET DEFAULT VALUES
            $japakOrder->setShopCode(get_option('wcjpk_webshop_code', ''));
            $japakOrder->setReference( get_option('wcjpk_webshop_code') . '-' .  $order->get_order_number() );

            // CUSTOMER
            $japakOrder->setCustomerCode( get_option('wcjpk_webshop_code') . '-' . $order->get_user_id() );

            // Set billing address
            $japakOrder->setBillingCountryCode($orderMeta['_billing_country'][0]);
            $japakOrder->setBillingNameFirst($orderMeta['_billing_first_name'][0]);
            $japakOrder->setBillingNameLast($orderMeta['_billing_last_name'][0]);
            $japakOrder->setBillingPhone($orderMeta['_billing_phone'][0]);
           

            if (isset($orderMeta['_billing_address_1'][0]) && strlen(trim($orderMeta['_billing_address_1'][0])) > 0) {
                $japakOrder->setBillingStreet( $orderMeta['_billing_address_1'][0] );
            }

            if (isset($orderMeta['_billing_house_number'][0]) && strlen(trim($orderMeta['_billing_house_number'][0])) > 0) {
                $japakOrder->setBillingHouseNumber( $orderMeta['_billing_house_number'][0] );
            }

            if (isset($orderMeta['_billing_addition'][0]) && strlen(trim($orderMeta['_billing_addition'][0])) > 0) {
                $japakOrder->setBillingHouseNumberAddon($orderMeta['_billing_addition'][0]);
            }

            $japakOrder->setBillingPostalCode($orderMeta['_billing_postcode'][0]);
            $japakOrder->setBillingEmail($orderMeta['_billing_email'][0]);
            $japakOrder->setBillingCity($orderMeta['_billing_city'][0]);
            $japakOrder->setBillingCompany($orderMeta['_billing_company'][0]);

            // Set shipping address
            $japakOrder->setShipmentNameFirst($orderMeta['_shipping_first_name'][0]);
	        $japakOrder->setShipmentNameLast($orderMeta['_shipping_last_name'][0]);
	            
            $japakOrder->setShipmentEmail($orderMeta['_billing_email'][0]);
			$japakOrder->setShipmentPhone($orderMeta['_billing_phone'][0]);
            $japakOrder->setShipmentCountryCode($orderMeta['_shipping_country'][0]);
            
            if (isset($orderMeta['_shipping_address_1'][0]) && strlen(trim($orderMeta['_shipping_address_1'][0])) > 0) {
                $japakOrder->setShipmentStreet( $orderMeta['_shipping_address_1'][0] );
            }

            if (isset($orderMeta['_shipping_house_number'][0]) && strlen(trim($orderMeta['_shipping_house_number'][0])) > 0) {
                $japakOrder->setShipmentHouseNumber( $orderMeta['_shipping_house_number'][0] );
            }

            if (isset($orderMeta['_shipping_addition'][0]) && strlen(trim($orderMeta['_shipping_addition'][0])) > 0) {
                $japakOrder->setShipmentHouseNumberAddon( $orderMeta['_shipping_addition'][0] );
            }

            $japakOrder->setShipmentPostalCode($orderMeta['_shipping_postcode'][0]);
            $japakOrder->setShipmentCity($orderMeta['_shipping_city'][0]);
            $japakOrder->setShipmentCompany($orderMeta['_shipping_company'][0]);
                                                
            foreach ($order->get_items() as $item_id => $item) {
	            $item_data = $item->get_data();
	            
	            $itemProductId = isset($item_data['variation_id']) && intval($item_data['variation_id']) > 0 ?
                    intval($item_data['variation_id']) : intval($item_data['product_id']);
	            				
				if ($itemProductId) {
					$sku = get_post_meta($itemProductId, '_sku', true);
	
	                $oderLine = new Japak_Objects_OrderLine();
	                $oderLine->setItemCode($sku);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setPrice($item_data['subtotal']);
	                } else {
	                    $oderLine->setPrice(0);
	                }
	
	                $oderLine->setAmount($item_data['quantity']);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setAmount($item_data['total']);
	                } else {
	                    $oderLine->setRowTotal(0);
	                }
	
	                $japakOrder->addOrderLine($oderLine);
				}
	        }
	        
/*
	        try {
		        $xml = '<Orders>' . Japak_Serializer_OrderSerializer::serialize($japakOrder) . '</Orders>';
                $result = $this->getJapakCommunication()->sendRequest($xml);
                var_dump($result);
                exit;
                
            } catch (Exception $ex) {
	            var_dump($ex->getMessage());
            }
*/
			
			header('Content-Type: application/xml');
            echo '<Orders>' . Japak_Serializer_OrderSerializer::serialize($japakOrder) . '</Orders>';
	        exit;
        }

        public function runCronMinutly()
        {
	        $this->writeFileLog('runCronMinutly');
	        $this->syncStock();
	        $this->runQueue();
        }

        protected function updateQueueStatus($id, $status, $extraData = array())
        {
            global $wpdb;

            $tableName = $wpdb->prefix . WCJPK_DATABASE_ORDER_SYNC_TABLENAME;

            return $wpdb->update(
                $tableName,
                array_merge(array(
                    'status' => $status,
                    'updated_at' => current_time('mysql')
                ), $extraData),
                array(
                    'id' => $id
                )
            );
        }

        public function runQueue()
        {
            global $wpdb;
                                    
            $tableName = $wpdb->prefix . WCJPK_DATABASE_ORDER_SYNC_TABLENAME;

            $next = $wpdb->get_row("SELECT * FROM `$tableName` WHERE `status` = 'waiting' OR (`status` = 'error' AND `attempts` <= 5) ORDER BY `created_at` ASC");
            			
			if ($next) {
                $this->updateQueueStatus($next->id, 'processing');
                
                $attempts = intval($next->attempts) + 1;
                
                $extraData = array(
                    'attempts' => $attempts
                );

                if ($this->sendOrder($next)) {
                    $this->updateQueueStatus($next->id, 'done', $extraData);
                } else {
	                if ($attempts > 5) {
		                $this->updateQueueStatus($next->id, 'error', $extraData);
	                } else {
		                $this->updateQueueStatus($next->id, 'waiting', $extraData);
	                }
                }
            }
        }
        
        protected function sendOrder($next)
        {
            $orderData = get_post($next->orderId);

            if (!$orderData || $orderData->post_type !== 'shop_order' || $orderData->post_status == 'trash') {
                return false;
            }
            
            $order = wc_get_order($orderData->ID);
            
            if (!$order->is_paid()) {
	            return false;
            }
            
            $orderMeta = get_post_meta($orderData->ID);

            $japakOrder = new Japak_Objects_Order();

            // SET DEFAULT VALUES
            $japakOrder->setShopCode(get_option('wcjpk_webshop_code', ''));
            $japakOrder->setReference( get_option('wcjpk_webshop_code') . '-' .  $order->get_order_number() );

            // CUSTOMER
            $japakOrder->setCustomerCode( get_option('wcjpk_webshop_code') . '-' . $order->get_user_id() );

            // Set billing address
            $japakOrder->setBillingCountryCode($orderMeta['_billing_country'][0]);
            $japakOrder->setBillingNameFirst($orderMeta['_billing_first_name'][0]);
            $japakOrder->setBillingNameLast($orderMeta['_billing_last_name'][0]);
            $japakOrder->setBillingPhone($orderMeta['_billing_phone'][0]);
           

            if (isset($orderMeta['_billing_address_1'][0]) && strlen(trim($orderMeta['_billing_address_1'][0])) > 0) {
                $japakOrder->setBillingStreet( $orderMeta['_billing_address_1'][0] );
            }

            if (isset($orderMeta['_billing_house_number'][0]) && strlen(trim($orderMeta['_billing_house_number'][0])) > 0) {
                $japakOrder->setBillingHouseNumber( $orderMeta['_billing_house_number'][0] );
            }

            if (isset($orderMeta['_billing_addition'][0]) && strlen(trim($orderMeta['_billing_addition'][0])) > 0) {
                $japakOrder->setBillingHouseNumberAddon($orderMeta['_billing_addition'][0]);
            }

            $japakOrder->setBillingPostalCode($orderMeta['_billing_postcode'][0]);
            $japakOrder->setBillingEmail($orderMeta['_billing_email'][0]);
            $japakOrder->setBillingCity($orderMeta['_billing_city'][0]);
            $japakOrder->setBillingCompany($orderMeta['_billing_company'][0]);

            // Set shipping address
            $japakOrder->setShipmentNameFirst($orderMeta['_shipping_first_name'][0]);
	        $japakOrder->setShipmentNameLast($orderMeta['_shipping_last_name'][0]);
	            
            $japakOrder->setShipmentEmail($orderMeta['_billing_email'][0]);
			$japakOrder->setShipmentPhone($orderMeta['_billing_phone'][0]);
            $japakOrder->setShipmentCountryCode($orderMeta['_shipping_country'][0]);
            
            if (isset($orderMeta['_shipping_address_1'][0]) && strlen(trim($orderMeta['_shipping_address_1'][0])) > 0) {
                $japakOrder->setShipmentStreet( $orderMeta['_shipping_address_1'][0] );
            }

            if (isset($orderMeta['_shipping_house_number'][0]) && strlen(trim($orderMeta['_shipping_house_number'][0])) > 0) {
                $japakOrder->setShipmentHouseNumber( $orderMeta['_shipping_house_number'][0] );
            }

            if (isset($orderMeta['_shipping_addition'][0]) && strlen(trim($orderMeta['_shipping_addition'][0])) > 0) {
                $japakOrder->setShipmentHouseNumberAddon( $orderMeta['_shipping_addition'][0] );
            }

            $japakOrder->setShipmentPostalCode($orderMeta['_shipping_postcode'][0]);
            $japakOrder->setShipmentCity($orderMeta['_shipping_city'][0]);
            $japakOrder->setShipmentCompany($orderMeta['_shipping_company'][0]);
            
            $japakItemCount = 0;
                                                
            foreach ($order->get_items() as $item_id => $item) {
	            $item_data = $item->get_data();
	            
	            $itemProductId = isset($item_data['variation_id']) && intval($item_data['variation_id']) > 0 ?
                    intval($item_data['variation_id']) : intval($item_data['product_id']);
	            				
				if ($itemProductId) {
					$sku = get_post_meta($itemProductId, '_sku', true);
	
	                $oderLine = new Japak_Objects_OrderLine();
	                $oderLine->setItemCode($sku);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setPrice($item_data['subtotal']);
	                } else {
	                    $oderLine->setPrice(0);
	                }
	
	                $oderLine->setAmount($item_data['quantity']);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setAmount($item_data['total']);
	                } else {
	                    $oderLine->setRowTotal(0);
	                }
	
	                $japakOrder->addOrderLine($oderLine);
				}
				$japakItemCount++;
	        }
	       	        
            if ($japakItemCount > 0) {
	            $xml = '<Orders>' . Japak_Serializer_OrderSerializer::serialize($japakOrder) . '</Orders>';
	            	
	            try {
	                $result = $this->getJapakCommunication()->sendRequest($xml);
	                	               
	                if (isset($result->ResultCode) && (string)$result->ResultCode === 'I00') {
	                    // Add note
	                    $order->add_order_note('Bestelling is verstuurd naar Japak');
	
	                    // Update order status
	                    $order->update_status('completed');
	                } else {
	                    $order->add_order_note('Bestelling is niet verstuurd naar Japak. Foutmelding: ' . (string)$result->ResultDescription);
	                    throw new Exception((string)$result->ResultDescription);
	                }
	                	               	
	                return true;
	
	            } catch (Exception $ex) {
	                $this->writeFileLog('Send order exception: ' .  $ex->getMessage(), array('id' => $next->orderId));
	            }
            } else {
	            // Add note
	            $order->add_order_note('Bestelling hoeft niet naar Japak verstuurd te worden');
	            
	            // Update order status
	            $order->update_status('completed');
	                    
	            return true;
            }

            return false;
        }
        
        public function syncStock()
        {
	        $this->stockInSync = true;

			if (isset($_GET['japak_test_reset'])) {
				update_option( 'wcjpk_changed_stock_token', 0 );
				update_option( 'wcjpk_changed_stock_assembly_token', 0 );
			}
	        	        	         
	        $changedStockToken = (int)get_option('wcjpk_changed_stock_token', 0);
	        
	        list($token, $productStocks) = $this->getJapakCommunication()->getChangedStock(
		        get_option('wcjpk_webshop_sku_prefix'),
		        $changedStockToken
			);
			
			$changedStockAssemblyToken = (int)get_option('wcjpk_changed_stock_assembly_token', 0);
			
			list($assemblyToken, $productAssemblyStocks) = $this->getJapakCommunication()->getChangedAssemblyStock(
		        get_option('wcjpk_webshop_sku_prefix'),
		        $changedStockAssemblyToken
			);
			
	        global $wpdb;
	        
	        $skuPostIds = array();
			
			foreach ($wpdb->get_results( "SELECT pm.post_id, pm.meta_value FROM $wpdb->postmeta AS pm LEFT JOIN $wpdb->posts AS p ON p.id = pm.post_id where pm.meta_key = '_sku' AND p.post_status = 'publish'") as $postmeta) {
				if (strlen(trim($postmeta->meta_value)) > 0) {
					$skuPostIds[$postmeta->meta_value] = intval($postmeta->post_id);
				}
			}
			
			$updates = 0;
				        
	        foreach ($productStocks as $productStock) {
		        if (!isset($skuPostIds[$productStock->getItemCode()])) {
			        continue;
		        }
		        
		        $productID = $skuPostIds[$productStock->getItemCode()];
		        
		        wc_update_product_stock($productID, (int)$productStock->getStock());
		        $updates++;
	        }
	        	        
	        foreach ($productAssemblyStocks as $productAssemblyStock) {
		        if (!isset($skuPostIds[$productAssemblyStock->getItemCode()])) {
			        continue;
		        }
		        
		        $productID = $skuPostIds[$productAssemblyStock->getItemCode()];
		        
		        wc_update_product_stock($productID, (int)$productAssemblyStock->getStock());
		        $updates++;
	        }
	        
	        update_option( 'wcjpk_changed_stock_token', $token );
	        update_option( 'wcjpk_changed_stock_assembly_token', $assemblyToken );
	        
	        $this->stockInSync = false;
        }

        public function registerSettings()
        {
            foreach ($this->options as $key => $option) {
                register_setting('wcjpk-options', $key);
            }
        }

        //Access to page of Settings in menu Plugin
        public function loadSettings()
        {
            add_options_page(
                sprintf('%s Settings', PLUGIN_NAME_WOOCOMMERCE),
                'Japak Synchronisatie',
                'manage_options',
                WCJPK_PLUGIN_NAME,
                array($this, 'renderSettings')
            );
        }

        public function renderSettings()
        {
            include(WCJPK_PLUGIN_DIR.'templates/woocommerce-japak-settings.php');
        }

        //Obtain info of plugins and save information
        public function initPlugin()
        {
            $plugins = get_plugins();

            define('PLUGIN_NAME_WOOCOMMERCE', $plugins[WCJPK_PLUGIN]['Name']);
            define('PLUGIN_VERSION_WOOCOMMERCE', $plugins[WCJPK_PLUGIN]['Version']);
        }

        public function orderStatusChanged($orderId)
        {
            global $wpdb;
            
            $tableName =  $wpdb->prefix . WCJPK_DATABASE_ORDER_SYNC_TABLENAME;
            $exists = $wpdb->get_row("SELECT * FROM `$tableName` WHERE `orderId` = " . intval($orderId));
                        
            if (!$exists) {
	            $wpdb->insert(
	                $tableName,
	                array(
	                    'orderId' => $orderId,
	                    'created_at' => current_time('mysql')
	                )
	            );
            } else {
	            
            }
        }

        /**
         * Write a string to log file.
         *
         * @param string $message
         */
        protected function writeFileLog($message, $extraData = array())
        {
	        @date_default_timezone_set('Europe/Amsterdam');
	        
	        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			    $ip = $_SERVER['HTTP_CLIENT_IP'];
			} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			} else if(isset($_SERVER['REMOTE_ADDR'])) {
			    $ip = $_SERVER['REMOTE_ADDR'];
			} else {
				$ip = '';
			}

            $myFile = __DIR__.'/logs/logs-' . date('d-m-Y') . '.txt';
            $date = date('d-m-Y H:i:s');
            $message =  $date . " from " . $ip . " " . php_sapi_name() .  " : " . print_r($message, true) . "\r\n";
            
            if (file_exists($myFile)) {
                $fh = @fopen($myFile, 'a') or die();
            } else {
                $fh = @fopen($myFile, 'w') or die();
            }

            @fwrite($fh, $message);
            @fclose($fh);
        }
    }
}