<?php
class Japak_Objects_Item
{
	/**
	 * @var string Assembly, Stock, Text
	 */
	protected $type = Japak_Objects_ItemTypes::Stock;

	/**
	 * @var string
	 */
	protected $itemCode = '';

	/**
	 * @var string
	 */
	protected $description = '';

	/**
	 * @var string
	 */
	protected $brand = '';

	/**
	 * @var string
	 */
	protected $brandGroup = '';

	/**
	 * @var integer
	 */
	protected $vatCode = 2;

	/**
	 * @var boolean
	 */
	protected $stockOverwrite = true;

	/**
	 * @var integer
	 */
	protected $stock = 0;

	/**
	 * @var decimal
	 */
	protected $costPrice = 0.0;

	/**
	 * @var decimal
	 */
	protected $price = 0.0;

	/**
	 * @var string
	 */
	protected $location = '';

	/**
	 * @var string EndOfLife, EndOfSale or Active
	 */
	protected $itemStatus = Japak_Objects_ItemStatus::Active;

	/**
	 * @var string
	 */
	protected $barcode = '';

	/**
	 * @var string
	 */
	protected $imageURL = '';

	/**
	 * @var array
	 */
	protected $assemblyItems;

	/**
	 * @param string $type
	 */
	public function setType($type)
	{
		$this->type = $type;
	}

	public function getType()
	{
		return $this->type;
	}

	// ITEMCODE
	public function setItemCode($itemCode)
	{
		$this->itemCode = trim($itemCode);
	}

	public function getItemCode()
	{
		return $this->itemCode;
	}

	// BRAND
	public function setBrand($brand)
	{
		$this->brand = trim($brand);
	}

	public function getBrand()
	{
		return $this->brand;
	}

	// BRANDGROUP
	public function setBrandGroup($brandGroup)
	{
		$this->brandGroup = trim($brandGroup);
	}

	public function getBrandGroup()
	{
		return $this->brandGroup;
	}

	// VATCODE
	public function setVATCode($vatCode)
	{
		$this->vatCode = intval($vatCode);
	}

	public function setVAT($procent)
	{
		$vatCode = 0;

		switch(intval($procent))
		{
			case 21:
				$vatCode = 2;
				break;
			case 6:
				$vatCode = 1;
				break;
		}

		$this->vatCode = $vatCode;
	}

	public function getVATCode()
	{
		return $this->vatCode;
	}

	// STOCK OVERWRITE
	public function getStockOverwrite()
	{
		return $this->stockOverwrite;
	}

	public function setStockOverwrite($stockOverwrite)
	{
		$this->stockOverwrite = (bool)$stockOverwrite;
	}

	// COST PRICE
	public function issetCostPrice()
	{
		return (floatval($this->costPrice) > 0) ? true : false;
	}

	public function setCostPrice($costPrice)
	{
		$this->costPrice = floatval($costPrice);
	}

	public function getCostPrice()
	{
		return $this->costPrice;
	}

	// PRICE
	public function issetPrice()
	{
		return (floatval($this->price) > 0) ? true : false;
	}

	public function setPrice($price)
	{
		$this->price = floatval($price);
	}

	public function getPrice()
	{
		return $this->price;
	}

	// STOCK
	public function issetStock()
	{
		return (intval($this->stock) > 0) ? true : false;
	}

	public function setStock($stock)
	{
		$this->stock = intval($stock);
	}

	public function getStock()
	{
		return $this->stock;
	}

	// LOCATION
	public function issetLocation()
	{
		return (strlen(trim($this->location)) > 0) ? true : false;
	}

	public function setLocation($location)
	{
		$this->location = trim($location);
	}

	public function getLocation()
	{
		return $this->location;
	}

	// DESCRIPTION
	public function setDescription($description)
	{
		if (strlen(trim($description)) > 255) {
			$description = substr($description . '...', 0, 251);
		}

		$this->description = trim($description);
	}

	public function getDescription()
	{
		return $this->description;
	}

	// ITEMSTATUS
	public function setItemStatus($itemStatus)
	{
		$this->itemStatus = trim($itemStatus);
	}

	public function getItemStatus()
	{
		return $this->itemStatus;
	}

	// BARCODE
	public function issetBarcode()
	{
		return (strlen(trim($this->barcode)) > 0) ? true : false;
	}

	public function setBarcode($barcode)
	{
		$this->barcode = trim($barcode);
	}

	public function getBarcode()
	{
		return $this->barcode;
	}

	// IMAGEURL
	public function issetImageURL()
	{
		return (strlen(trim($this->imageURL)) > 0) ? true : false;
	}

	public function setImageURL($imageURL)
	{
		$this->imageURL = trim($imageURL);
	}

	public function getImageURL()
	{
		return $this->imageURL;
	}

	// ASSEMBLY ITEMS
	public function setAssemblyItems($assemblyItems)
	{
		$this->assemblyItems = $assemblyItems;
	}

	public function setAssemblyItem(Japak_Objects_AssemblyItem $assemblyItem)
	{
		$this->assemblyItems[] = $assemblyItem;
	}

	public function getAssemblyItems()
	{
		return $this->assemblyItems;
	}
}