<?php

if (!class_exists('WoocommerceJapak'))
{

    class WoocommerceJapak
    {
        /**
         * @var Japak_Communication
         */
        protected $japakCommunication;
        
        protected $stockInSync = false;

        /**
         * @var array
         */
        protected $options = array(
            'wcjpk_enabled' => array('label' => 'Ingeschakeld', 'type' => 'checkbox', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_application_name' => array('label' => 'Applicatie naam', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_application_id' => array('label' => 'Applicatie ID', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_security_code' => array('label' => 'Security code', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_webservice_url' => array('label' => 'Webservice URL', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_webshop_code' => array('label' => 'ShopCode', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_webshop_sku_prefix' => array('label' => 'Artikelnr. startnummer', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_brand' => array('label' => 'Merk', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_brand_group' => array('label' => 'Merk groep', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_warehouse_id' => array('label' => 'Magazijn ID', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_stock_notice_email' => array('label' => 'Lage voorraad meldingen e-mailadres', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_enable_payments' => array('label' => 'Betalingen ingeschakeld', 'type' => 'checkbox', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
            'wcjpk_from_email' => array('label' => 'Van e-mailadres', 'type' => 'text', 'required' => true, 'descr' => '', 'notice' => 'This can not be empty!'),
			'wcjpk_pickup_country_code' => array('label' => 'Pickup Country Code', 'type' => 'text', 'required' => false, 'descr' => '', 'notice' => ''),
			'wcjpk_pickup_street' => array('label' => 'Pickup Street', 'type' => 'text', 'required' => false, 'descr' => '', 'notice' => ''),
			'wcjpk_pickup_house_number' => array('label' => 'Pickup House Number', 'type' => 'text', 'required' => false, 'descr' => '', 'notice' => ''),
			'wcjpk_pickup_house_number_addon' => array('label' => 'Pickup House Number Addon Code', 'type' => 'text', 'required' => false, 'descr' => '', 'notice' => ''),
			'wcjpk_pickup_postal' => array('label' => 'Pickup Postal', 'type' => 'text', 'required' => false, 'descr' => '', 'notice' => ''),
			'wcjpk_pickup_city' => array('label' => 'Pickup City', 'type' => 'text', 'required' => false, 'descr' => '', 'notice' => ''),
			'wcjpk_pickup_company' => array('label' => 'Pickup Company', 'type' => 'text', 'required' => false, 'descr' => '', 'notice' => ''),
        );

        public function __construct()
        {    
            // call init
            $this->init();
        }

        public function getJapakCommunication()
        {
            // Lazy loading
            if (!$this->japakCommunication) {
                $this->japakCommunication = new Japak_Communication(
                    get_option('wcjpk_application_name'),
                    get_option('wcjpk_application_id'),
                    get_option('wcjpk_security_code'),
                    get_option('wcjpk_webservice_url'),
                    get_option('wcjpk_webshop_code'),
                    get_option('wcjpk_webshop_sku_prefix')
                );
            }
            
            return $this->japakCommunication;
        }

        private function dump($input)
        {
            echo '<pre>' . print_r($input, true) . '</pre>';
        }

        public function isPaymentsEnabled()
        {
            return get_option('wcjpk_enable_payments') && intval(get_option('wcjpk_enable_payments')) == 1;
        }

        public function isEnabled()
        {
            return get_option('wcjpk_enabled') && intval(get_option('wcjpk_enabled')) == 1;
        }

        public function activation()
        {
            if (!wp_next_scheduled ( 'wcjpk_cron_every_minut' )) {
                wp_schedule_event( time(), 'every_minut', 'wcjpk_cron_every_minut' );
            }
            
            if (!wp_next_scheduled ( 'wcjpk_cron_daily' )) {
                wp_schedule_event( time(), 'daily', 'wcjpk_cron_daily' );
            }
        }
        
        public function deactivation()
        {
	        wp_clear_scheduled_hook('wcjpk_cron_every_minut');
	        wp_clear_scheduled_hook('wcjpk_cron_daily');
        }

        //Initializes WordPress hooks
        private function init()
        {
            // HOOKS ADMIN
            if (is_admin()) {
                add_action('admin_menu', array($this, 'initPlugin'));
                add_action('admin_init', array($this, 'registerSettings'));
                add_action('admin_menu', array($this, 'loadSettings'));
            }

            // HOOKS WOOCOMMERCE - ORDER Status

            if (function_exists('wc_jpksup_is_supervisor')) {
                add_action('woocommerce_order_approved', array($this, 'orderStatusChanged'));
            } else {
                add_action('woocommerce_order_status_pending', array($this, 'orderStatusChanged'));
                add_action('woocommerce_order_status_failed', array($this, 'orderStatusChanged'));
                add_action('woocommerce_order_status_on-hold', array($this, 'orderStatusChanged'));
                add_action('woocommerce_order_status_processing', array($this, 'orderStatusChanged'));
                add_action('woocommerce_order_status_completed', array($this, 'orderStatusChanged'));
                add_action('woocommerce_order_status_refunded', array($this, 'orderStatusChanged'));
                add_action('woocommerce_order_status_cancelled', array($this, 'orderStatusChanged'));
            }

            add_action('woocommerce_after_register_post_type', array($this, 'checkLowStockAmount'));
            add_action('woocommerce_product_after_variable_attributes', array($this, 'afterVariableAttributes'), 10, 3 );
            add_action('woocommerce_save_product_variation', array($this, 'saveVariationFields'), 10, 2 );
            
/*
            add_filter( 'woocommerce_billing_fields', array( $this, 'billingFields' ), 10, 2 );
			add_filter( 'woocommerce_shipping_fields', array( $this, 'shippingFields' ), 10, 2 );
			add_filter( 'woocommerce_get_country_locale', array( $this, 'woocommerceLocale' ), 1, 1);
			add_filter( 'woocommerce_country_locale_field_selectors', array( $this, 'countryLocaleFieldSelectors' ) );
			add_filter( 'woocommerce_default_address_fields', array( $this, 'defaultAddressFields' ) );
			add_filter( 'woocommerce_load_order_data', array( &$this, 'loadOrderData' ) );
*/


            if ($this->isEnabled()) {
                // HOOKS - PRODUCT Update
                add_action('save_post', array($this, 'savePost'), 13, 2);
                add_action('admin_notices', array($this,'adminNotice'));
                                

                if (isset($_GET['japak_test'])) {
	                add_action('woocommerce_after_register_post_type', array($this, 'japakTest'));
                }

                // Cronjob
                add_action('wcjpk_cron_every_minut', array($this, 'runCronMinutly'));
                add_action('wcjpk_cron_daily', array($this, 'runCronDaily'));
            }
        }
        
        public function loadOrderData()
        {
	        // Billing
			$data['billing_street_name']			= '';
			$data['billing_house_number']			= '';
			$data['billing_house_number_suffix']	= '';		
		
			// Shipping
			$data['shipping_street_name']			= '';
			$data['shipping_house_number']			= '';
			$data['shipping_house_number_suffix']	= '';
		
			return $data;
        }
        
        public function defaultAddressFields($fields)
        {
	        $custom_fields = array(
				'street_name' => array(
					'hidden'	=> false,
					'required'	=> true,
				),
				'house_number' => array(
					'hidden'	=> false,
					'required'	=> true,
				),
				'house_number_suffix' => array(
					'hidden'	=> false,
					'required'	=> true,
				),
	
			);
	
			$fields = array_merge( $fields,$custom_fields );
	
			return $fields;
        }
        
        public function countryLocaleFieldSelectors($locale_fields)
        {
		    $custom_locale_fields = array(
				'street_name'  => '#billing_street_name_field, #shipping_street_name_field',
				'house_number'  => '#billing_house_number_field, #shipping_house_number_field',
				'house_number_suffix'  => '#billing_house_number_suffix_field, #shipping_house_number_suffix_field',
			);
	
			$locale_fields = array_merge( $locale_fields, $custom_locale_fields );
	
			return $locale_fields;
        }
        
        public function woocommerceLocale($locale)
        {
	        $locale[$locale]['address_1'] = array(
				'required'  => false,
				'hidden'	=> true,
			);
	
			$locale[$locale]['address_2'] = array(
				'hidden'	=> true,
			);
			
			$locale[$locale]['state'] = array(
				'hidden'	=> true,
				'required'	=> false,
			);
	
			$locale[$locale]['street_name'] = array(
				'required'  => true,
				'hidden'	=> false,
			);
	
			$locale[$locale]['house_number'] = array(
				'required'  => true,
				'hidden'	=> false,
			);
	
			$locale[$locale]['house_number_suffix'] = array(
				'required'  => false,
				'hidden'	=> false,
			);
	
			return $locale;
        }
        
        private function checkoutFields($fields, $form)
        {
	        if (isset($fields['_country'])) {
				// some weird bug on the my account page
				$form = '';
			}
	
			$fields[$form.'_street_name'] = array(
				'label'			=> __( 'Street name', 'woocommerce-myparcel' ),
				'placeholder'	=> __( 'Street name', 'woocommerce-myparcel' ),
				'class'			=> array( 'form-row-first' ),
				'required'		=> true
			);
	
			$fields[$form.'_house_number'] = array(
				'label'			=> __( 'Nr.', 'woocommerce-myparcel' ),
				'class'			=> array( 'form-row-quart-first' ),
				'required'		=> true,
				'type'			=> 'number',
			);
	
			// Add house number Suffix
			$fields[$form.'_house_number_suffix'] = array(
				'label'			=> __( 'Suffix', 'woocommerce-myparcel' ),
				'class'			=> array( 'form-row-quart' ),
				'required'		=> false,
			);
	
	        // Create new ordering for checkout fields
	        $order_keys = array (
	            $form.'_first_name',
	            $form.'_last_name',
	            $form.'_company',
	            $form.'_country',
	            $form.'_address_1',
	            $form.'_address_2',
	            $form.'_street_name',
	            $form.'_house_number',
	            $form.'_house_number_suffix',
	            $form.'_postcode',
	            $form.'_city',
	            $form.'_state',
	        );
	
			if ($form == 'billing') {
				array_push ($order_keys,
					$form.'_email',
					$form.'_phone'
				);
			}
	
			$new_order = array();
			
			// Create reordered array and fill with old array values
			foreach ($order_keys as $key) {
				$new_order[$key] = $fields[$key];
			}
			
			// Merge (&overwrite) field array
			$fields = array_merge($new_order, $fields);
				
			return $fields;
        }
        
        public function billingFields($fields) 
        {
	        // billing
	        return $this->checkoutFields($fields, 'billing');
        }
        
        public function shippingFields($fields) 
        {
	        // shipping
	        return $this->checkoutFields($fields, 'shipping');

        }
        
        
        public function afterVariableAttributes($loop, $variation_data, $variation) 
        {
			woocommerce_wp_text_input( array( 
				'id' => '_variant_low_stock_treshold['. $loop .']', 
				'label' => __( 'Low stock treshold ', 'woocommerce' ), 
				'wrapper_class' => 'form-row', 
				'type' => 'number', 
				'value' => get_post_meta($variation->ID, '_variant_low_stock_treshold', true), 
				'custom_attributes' => array( 
					'step' => '1', 
					'min' => '0' 
				) 
			));
        }
        
        public function saveVariationFields($variation_id, $i)
        {
	        $lowStockTresholdField = $_POST['_variant_low_stock_treshold'][$i]; 
	        update_post_meta( $variation_id, '_variant_low_stock_treshold', esc_attr( $lowStockTresholdField ) );
        }
        
        public function japakTest()
        {
	        $orderData = get_post(883);

            $order = wc_get_order($orderData->ID);
            $orderMeta = get_post_meta($orderData->ID);

            $japakOrder = new Japak_Objects_Order();

            // SET DEFAULT VALUES
            $japakOrder->setShopCode(get_option('wcjpk_webshop_code', ''));
            $japakOrder->setReference( get_option('wcjpk_webshop_code') . '-' .  $order->get_order_number() );

            // CUSTOMER
            $japakOrder->setCustomerCode( get_option('wcjpk_webshop_code') . '-' . $order->get_user_id() );

            // Set billing address
            $japakOrder->setBillingCountryCode($orderMeta['_billing_country'][0]);
            $japakOrder->setBillingNameFirst($orderMeta['_billing_first_name'][0]);
            $japakOrder->setBillingNameLast($orderMeta['_billing_last_name'][0]);
            $japakOrder->setBillingPhone($orderMeta['_billing_phone'][0]);
           

            if (isset($orderMeta['_billing_street_name'][0]) && strlen(trim($orderMeta['_billing_street_name'][0])) > 0) {
                $japakOrder->setBillingStreet( $orderMeta['_billing_street_name'][0] );
            }

            if (isset($orderMeta['_billing_house_number'][0]) && strlen(trim($orderMeta['_billing_house_number'][0])) > 0) {
                $japakOrder->setBillingHouseNumber( $orderMeta['_billing_house_number'][0] );
            }

            if (isset($orderMeta['_billing_house_number_suffix'][0]) && strlen(trim($orderMeta['_billing_house_number_suffix'][0])) > 0) {
                $japakOrder->setBillingHouseNumberAddon($orderMeta['_billing_house_number_suffix'][0]);
            }

            $japakOrder->setBillingPostalCode($orderMeta['_billing_postcode'][0]);
            $japakOrder->setBillingEmail($orderMeta['_billing_email'][0]);
            $japakOrder->setBillingCity($orderMeta['_billing_city'][0]);
            $japakOrder->setBillingCompany($orderMeta['_billing_company'][0]);

            // Set shipping address
            $japakOrder->setShipmentNameFirst($orderMeta['_shipping_first_name'][0]);
	        $japakOrder->setShipmentNameLast($orderMeta['_shipping_last_name'][0]);
	            
            if ( stripos(trim($order->get_shipping_method()), 'pickup') === 0 ) {
	            $japakOrder->setShipmentCountryCode( get_option( 'wcjpk_pickup_country_code' ) );
	            $japakOrder->setShipmentStreet( get_option( 'wcjpk_pickup_street' ) );
	            $japakOrder->setShipmentHouseNumber( get_option( 'wcjpk_pickup_house_number' )  );
	            $japakOrder->setShipmentHouseNumberAddon( get_option( 'wcjpk_pickup_house_number_addon' ) );	
	            $japakOrder->setShipmentPostalCode( get_option( 'wcjpk_pickup_postal' ) );
	            $japakOrder->setShipmentCity( get_option( 'wcjpk_pickup_city' ) );
	            $japakOrder->setShipmentCompany( get_option( 'wcjpk_pickup_company' ) );
            } else {
	            $japakOrder->setShipmentEmail($orderMeta['_billing_email'][0]);
				$japakOrder->setShipmentPhone($orderMeta['_billing_phone'][0]);
	            $japakOrder->setShipmentCountryCode($orderMeta['_shipping_country'][0]);
	            
	            if (isset($orderMeta['_shipping_street_name'][0]) && strlen(trim($orderMeta['_shipping_street_name'][0])) > 0) {
	                $japakOrder->setShipmentStreet( $orderMeta['_shipping_street_name'][0] );
	            }
	
	            if (isset($orderMeta['_shipping_house_number'][0]) && strlen(trim($orderMeta['_shipping_house_number'][0])) > 0) {
	                $japakOrder->setShipmentHouseNumber( $orderMeta['_shipping_house_number'][0] );
	            }
	
	            if (isset($orderMeta['_shipping_house_number_suffix'][0]) && strlen(trim($orderMeta['_shipping_house_number_suffix'][0])) > 0) {
	                $japakOrder->setShipmentHouseNumberAddon( $orderMeta['_shipping_house_number_suffix'][0] );
	            }
	
	            $japakOrder->setShipmentPostalCode($orderMeta['_shipping_postcode'][0]);
	            $japakOrder->setShipmentCity($orderMeta['_shipping_city'][0]);
	            $japakOrder->setShipmentCompany($orderMeta['_shipping_company'][0]);
            }

            $japakWarehouseID = intval(get_option('wcjpk_warehouse_id', 0));
            $sendToOtherWarehouses = array();
            
            $japakItemCount = 0;
            
            foreach ($order->get_items() as $item_id => $item) {
	            $item_data = $item->get_data();

	            $itemProductId = isset($item_data['variation_id']) && intval($item_data['variation_id']) > 0 ?
                    intval($item_data['variation_id']) : intval($item_data['product_id']);
	            				
				if ($itemProductId) {
					$sku = get_post_meta($itemProductId, '_sku', true);
	                $productFields = get_fields($item_data['product_id']);
	
	                if (isset($productFields['warehouse']) && intval($productFields['warehouse']) > 0) {
	                    if (intval($productFields['warehouse']) !== $japakWarehouseID) {
	
	                        if (isset($sendToOtherWarehouses[intval($productFields['warehouse'])])) {
	                            $sendToOtherWarehouses[intval($productFields['warehouse'])][] = $item;
	                        } else {
	                            $sendToOtherWarehouses[intval($productFields['warehouse'])] = array($item);
	                        }
	
	                        continue;
	                    }
	                }
	
	                $oderLine = new Japak_Objects_OrderLine();
	                $oderLine->setItemCode($sku);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setPrice($item_data['subtotal']);
	                } else {
	                    $oderLine->setPrice(0);
	                }
	
	                $oderLine->setAmount($item_data['quantity']);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setAmount($item_data['total']);
	                } else {
	                    $oderLine->setRowTotal(0);
	                }
	
	                $japakOrder->addOrderLine($oderLine);
	                $japakItemCount++;
				}
	        }
	        	        
	        $japakOrder->addExtraField('OrderedByName', $orderMeta['_shipping_first_name'][0] . ' ' . $orderMeta['_shipping_last_name'][0]);
	        $japakOrder->addExtraField('OrderedByPhone', $orderMeta['_billing_phone'][0]);
	        $japakOrder->addExtraField('OrderedByCompany', $orderMeta['_shipping_company'][0]);
	        $japakOrder->addExtraField('OrderedByEmail', $orderMeta['_billing_email'][0]);
	        
	        if ( stripos(trim($order->get_shipping_method()), 'pickup') === 0 ) {
		        $japakOrder->addExtraField('OrderType', 'Pickup');
		    } else {
			    $japakOrder->addExtraField('OrderType', 'Delivery');
		    }
			
			header('Content-Type: application/xml');
            echo '<Orders>' . Japak_Serializer_OrderSerializer::serialize($japakOrder) . '</Orders>';
	        exit;

                       
            if ($japakItemCount > 0) {
	            $xml = '<Orders>' . Japak_Serializer_OrderSerializer::serialize($japakOrder) . '</Orders>';
	
	            try {
	                $result = $this->getJapakCommunication()->sendRequest($xml);
	
	                if (isset($result->ResultCode) && (string)$result->ResultCode === 'I00') {
	                    // Add note
	                    $order->add_order_note('Bestelling is verstuurd naar Japak');
	
	                    // Update order status
	                    $order->update_status('completed');
	                } else {
	                    $order->add_order_note('Bestelling is niet verstuurd naar Japak. Foutmelding: ' . (string)$result->ResultDescription);
	                    throw new Exception((string)$result->ResultDescription);
	                }
	
	                return true;
	
	            } catch (Exception $ex) {
	                $this->writeFileLog('Send order exception: ' .  $ex->getMessage(), array('id' => $next->orderId), true);
	            }
            } else {
	            // Add note
	            $order->add_order_note('Bestelling hoeft niet naar Japak verstuurd te worden');
	            
	            // Update order status
	            $order->update_status('completed');
	                    
	            return true;
            }

            return false;
        }

        public function adminNotice()
        {
            $productSynced = get_transient( 'wcjpk_product_synced' );
            delete_transient( 'wcjpk_product_synced' );

            if ( $productSynced ) {
                echo '<div class="notice notice-success is-dismissible"><p>Het product is succesvol gesynchroniseerd met Japak</p></div>';
            }
        }
        
        public function runCron()
        {
	        $this->runQueue();
        }

        public function runCronMinutly()
        {
	        $this->writeFileLog('runCronMinutly');
	        $this->runQueue();
	        $this->syncStock();
        }
        
        public function runCronDaily()
        {
	        $this->writeFileLog('runCronDaily');
	        $this->syncStock();
            $this->checkLowStockAmount();
	    }
        
        public function syncStock()
        {
	        $this->stockInSync = true;
	        
	        $productStocks = $this->getJapakCommunication()->getStocks(
		        get_option('wcjpk_webshop_sku_prefix')
	        );
	      
	        global $wpdb;
	        
	        $skuPostIds = array();
			
			foreach ($wpdb->get_results( "SELECT pm.post_id, pm.meta_value FROM $wpdb->postmeta AS pm LEFT JOIN $wpdb->posts AS p ON p.id = pm.post_id where pm.meta_key = '_sku' AND p.post_status = 'publish'") as $postmeta) {
				if (strlen(trim($postmeta->meta_value)) > 0) {
					$skuPostIds[$postmeta->meta_value] = intval($postmeta->post_id);
				}
			}
	        
	        foreach ($productStocks as $productStock) {
		        if (!isset($skuPostIds[$productStock->getItemCode()])) {
			        continue;
		        }
		        
		        $productID = $skuPostIds[$productStock->getItemCode()];
		        
		        wc_update_product_stock($productID, intval($productStock->getStock()));
		        $this->updateLowStockNotify($productID);
	        }
	        
	        $this->stockInSync = false;
        }

        protected function updateQueueStatus($id, $status, $extraData = array())
        {
            global $wpdb;

            $tableName = $wpdb->prefix . WCJPK_DATABASE_ORDER_SYNC_TABLENAME;

            return $wpdb->update(
                $tableName,
                array_merge(array(
                    'status' => $status,
                    'updated_at' => current_time('mysql')
                ), $extraData),
                array(
                    'id' => $id
                )
            );
        }

        protected function runQueue()
        {
            global $wpdb;
                        
            $tableName = $wpdb->prefix . WCJPK_DATABASE_ORDER_SYNC_TABLENAME;

            $next = $wpdb->get_row("SELECT * FROM `$tableName` WHERE `status` = 'waiting' OR (`status` = 'error' AND `attempts` <= 5) ORDER BY `created_at` ASC");

			if ($next) {
                $this->updateQueueStatus($next->id, 'processing');
                
                $attempts = intval($next->attempts) + 1;
                
                $extraData = array(
                    'attempts' => $attempts
                );

                if ($this->sendOrder($next)) {
                    $this->updateQueueStatus($next->id, 'done', $extraData);
                } else {
	                if ($attempts > 5) {
		                $this->updateQueueStatus($next->id, 'error', $extraData);
	                } else {
		                $this->updateQueueStatus($next->id, 'waiting', $extraData);
	                }
                }
            }
        }
        
        protected function updateLowStockNotify($mainProductId, $otherProductIds = array())
        {
	        $mainProductFields = get_post_meta($mainProductId);
	        
	        if (isset($mainProductFields['_variant_low_stock_treshold'][0]) && intval($mainProductFields['_variant_low_stock_treshold'][0]) > 0) {
		        $lowStockNotifyTreshold = (int)$mainProductFields['_variant_low_stock_treshold'][0];
	        } else if (!isset($mainProductFields['low_stock_notify_value'][0]) || intval($mainProductFields['low_stock_notify_value'][0]) <= 0) {
				$lowStockNotifyTreshold = 5;
			} else {
				$lowStockNotifyTreshold = intval($mainProductFields['low_stock_notify_value'][0]);
			}
			
			if (count($otherProductIds) > 0) {
				foreach ($otherProductIds as $productId) {
	            	$productMeta = get_post_meta($productId);
	            	
	            	$currentStock = intval($productMeta['_stock'][0]);
	            	$currentLowStockNotifyTreshold = $lowStockNotifyTreshold;
	            	
	            	if (isset($productMeta['_variant_low_stock_treshold'][0]) && intval($productMeta['_variant_low_stock_treshold'][0]) > 0) {
		            	$currentLowStockNotifyTreshold = intval($productMeta['_variant_low_stock_treshold'][0]);
	            	}
	            						
					if (isset($productMeta['_stock'][0])) {
	                    $currentStock = intval($productMeta['_stock'][0]);
	
	                    if ($currentStock > $currentLowStockNotifyTreshold && isset($productMeta['_low_stock_notify_send'])) {
		                    delete_post_meta($productId, '_low_stock_notify_send');
	                    }
	                }
	            }
			} else {
				$mainProductMeta = get_post_meta($mainProductId);
				
				if (isset($mainProductMeta['_stock'][0])) {
                    $currentStock = intval($mainProductMeta['_stock'][0]);

                    if ($currentStock > $lowStockNotifyTreshold && isset($mainProductMeta['_low_stock_notify_send'])) {
                        delete_post_meta($mainProductId, '_low_stock_notify_send');
                    }
                }
			}
        }
        
        public function checkLowStockAmount()
        {
	        // Get all products
            $products = get_posts(array(
                'post_type' => 'product',
                'posts_per_page' => -1
            ));

            $productFactory = new WC_Product_Factory();
            $to = get_option('wcjpk_stock_notice_email');
            
            if (!$to || strlen(trim($to)) === 0) {
	            return;
            }
            
            foreach ($products as $product) {
                $productObject = $productFactory->get_product($product->ID);
                $productFields = get_fields($product->ID);
                
                
                if (!isset($productFields['low_stock_notify_value']) || intval($productFields['low_stock_notify_value']) <= 0) {
					$lowStockNotifyTreshold = 5;
				} else {
					$lowStockNotifyTreshold = intval($productFields['low_stock_notify_value']);
				}
				
				$productIds = array();

                if ($productObject->get_type() === 'variable') {
                    foreach ($productObject->get_available_variations() as $variation) {
                        $productIds[] = $variation['variation_id'];
                    }
                } else {
                    $productIds[] = $product->ID;
                }
                
                foreach ($productIds as $productId) {
	                $currentProduct = get_post($productId);
                    $productMeta = get_post_meta($productId);
                    $currentStock = intval($productMeta['_stock'][0]);
                    
                    $currentLowStockNotifyTreshold = $lowStockNotifyTreshold;
	            	
	            	if (isset($productMeta['_variant_low_stock_treshold'][0]) && intval($productMeta['_variant_low_stock_treshold'][0]) > 0) {
		            	$currentLowStockNotifyTreshold = intval($productMeta['_variant_low_stock_treshold'][0]);
	            	}
	            	
	                if ($currentStock <= $currentLowStockNotifyTreshold && !isset($productMeta['_low_stock_notify_send'][0])) {		                
		                $subject = sprintf('Productvoorraad van het product %s (SKU: %s) heeft de drempelwaarde bereikt', $currentProduct->post_title, $productMeta['_sku'][0]);
                        $body = sprintf('Productvoorraad van het product %s (SKU: %s) heeft de drempelwaarde %d bereikt. De huidige voorraad is %d.', $currentProduct->post_title, $productMeta['_sku'][0], $currentLowStockNotifyTreshold, $currentStock);
						
						if ($this->sendMail($to, $subject, $body, 'Product #' . $productId)) {
                            update_post_meta($productId, '_low_stock_notify_send', date('d-m-Y H:i:s')); 
                            $this->writeFileLog($body);
                        }
		            }
	            }
            }
        }
        
        public function mailTest()
        {
	        $to = get_option('wcjpk_stock_notice_email');
										
			if (!$to || strlen(trim($to)) === 0) {
				return;
			}
			
			$product_title = 'USB-stick (4GB)';
			$product_stock = 10;
			
			$subject = sprintf('Productvoorraad van het product %s heeft de drempelwaarde bereikt', $product_title);
			$body = sprintf('Productvoorraad van het product %s heeft de drempelwaarde %d bereikt. De huidige voorraad is %d.', $product_title, 100, $product_stock);
			
			$this->sendMail($to, $subject, $body, 'Bestelling #234324');
        }
        
        public function sendMail($to, $subject, $body, $title)
        {
			// message
			$message = '<!DOCTYPE html>
				<html dir="ltr">
					<head>
						<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
						<title>Nedschroef</title>
					</head>
					<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0">
						<div id="wrapper" dir="ltr" style="background-color: #f5f5f5; margin: 0; padding: 70px 0 70px 0; -webkit-text-size-adjust: none !important; width: 100%;">
							<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%"><tr>
								<td align="center" valign="top">
									<div id="template_header_image">
										<p style="margin-top: 0;"><img src="http://jpk-nedschroef:8888/wp-content/themes/storefront-japak/images/nedschroef-logo.png" alt="Nedschroef webshop" style="border: none; display: inline; font-size: 14px; font-weight: bold; height: auto; line-height: 100%; outline: none; text-decoration: none; text-transform: capitalize;"></p>
									</div>
									
									<table border="0" cellpadding="0" cellspacing="0" width="600" id="template_container" style="box-shadow: 0 1px 4px rgba(0,0,0,0.1) !important; background-color: #fdfdfd; border: 1px solid #dcdcdc; border-radius: 3px !important;">
										<tr>
											<td align="center" valign="top">
												<table border="0" cellpadding="0" cellspacing="0" width="600" id="template_header" style=\'background-color: #141b4d; border-radius: 3px 3px 0 0 !important; color: #ffffff; border-bottom: 0; font-weight: bold; line-height: 100%; vertical-align: middle; font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;\'>
													<tr>
														<td id="header_wrapper" style="padding: 36px 48px; display: block;">
															<h1 style=\'color: #ffffff; font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif; font-size: 30px; font-weight: 300; line-height: 150%; margin: 0; text-align: left; text-shadow: 0 1px 0 #6868af; -webkit-font-smoothing: antialiased;\'>' . $title . '</h1>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td align="center" valign="top">
												<table border="0" cellpadding="0" cellspacing="0" width="600" id="template_body">
													<tr>
														<td valign="top" id="body_content" style="background-color: #fdfdfd;">
															<table border="0" cellpadding="20" cellspacing="0" width="100%">
																<tr>
																	<td valign="top" style="padding: 48px;">
																		<div id="body_content_inner" style="color: #737373; font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif; font-size: 14px; line-height: 150%; text-align: left;">
																			' . $body . '
																		</div>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td align="center" valign="top">
												<table border="0" cellpadding="10" cellspacing="0" width="600" id="template_footer">
													<tr>
														<td valign="top" style="padding: 0; -webkit-border-radius: 6px;">
															<table border="0" cellpadding="10" cellspacing="0" width="100%">
																<tr>
																	<td colspan="2" valign="middle" id="credit" style="padding: 0 48px 48px 48px; -webkit-border-radius: 6px; border: 0; color: #8e8ec3; font-family: Arial; font-size: 12px; line-height: 125%; text-align: center;">
																		<p>Nedschroef</p>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</div>
				</body>
			</html>';
			
			$from_email = get_option('wcjpk_from_email');
			$headers = 'From: ' . get_bloginfo('name') . ' <' . $from_email . '>' . "\r\n";
											
			add_filter( 'wp_mail_content_type', array($this, 'wpdocsSetHtmlMailContentType') );
			$result = wp_mail($to, $subject, $message, $headers);
			remove_filter( 'wp_mail_content_type', array($this, 'wpdocsSetHtmlMailContentType') );
			
			return $result;
        }
        
        public function wpdocsSetHtmlMailContentType()
        {
	        return 'text/html';
        }

        protected function sendOrder($next)
        {
            $orderData = get_post($next->orderId);

            if (!$orderData || $orderData->post_type !== 'shop_order' || $orderData->post_status == 'trash') {
                return false;
            }

            $order = wc_get_order($next->orderId);
            $orderMeta = get_post_meta($orderData->ID);

            $japakOrder = new Japak_Objects_Order();

            // SET DEFAULT VALUES
            $japakOrder->setShopCode(get_option('wcjpk_webshop_code', ''));
            $japakOrder->setReference( get_option('wcjpk_webshop_code') . '-' .  $order->get_order_number() );

            if ( !$this->isPaymentsEnabled() ) {
                $japakOrder->setElectronicPaid(0);
            }

            // CUSTOMER
            $japakOrder->setCustomerCode( get_option('wcjpk_webshop_code') . '-' . $order->get_user_id() );

            // Set billing address
            $japakOrder->setBillingCountryCode($orderMeta['_billing_country'][0]);
            $japakOrder->setBillingNameFirst($orderMeta['_billing_first_name'][0]);
            $japakOrder->setBillingNameLast($orderMeta['_billing_last_name'][0]);
            $japakOrder->setBillingPhone($orderMeta['_billing_phone'][0]);

            if (isset($orderMeta['_billing_street_name'][0]) && strlen(trim($orderMeta['_billing_street_name'][0])) > 0) {
                $japakOrder->setBillingStreet( $orderMeta['_billing_street_name'][0] );
            }

            if (isset($orderMeta['_billing_house_number'][0]) && strlen(trim($orderMeta['_billing_house_number'][0])) > 0) {
                $japakOrder->setBillingHouseNumber( $orderMeta['_billing_house_number'][0] );
            }

            if (isset($orderMeta['_billing_house_number_suffix'][0]) && strlen(trim($orderMeta['_billing_house_number_suffix'][0])) > 0) {
                $japakOrder->setBillingHouseNumberAddon($orderMeta['_billing_house_number_suffix'][0]);
            }

            $japakOrder->setBillingPostalCode($orderMeta['_billing_postcode'][0]);
            $japakOrder->setBillingEmail($orderMeta['_billing_email'][0]);
            $japakOrder->setBillingCity($orderMeta['_billing_city'][0]);
            $japakOrder->setBillingCompany($orderMeta['_billing_company'][0]);
            
            // Set shipping address
            $japakOrder->setShipmentNameFirst($orderMeta['_shipping_first_name'][0]);
            $japakOrder->setShipmentNameLast($orderMeta['_shipping_last_name'][0]);
            
            if ( stripos(trim($order->get_shipping_method()), 'pickup') === 0 ) {
	            $japakOrder->setShipmentCountryCode( get_option( 'wcjpk_pickup_country_code' ) );
	            $japakOrder->setShipmentStreet( get_option( 'wcjpk_pickup_street' ) );
	            $japakOrder->setShipmentHouseNumber( get_option( 'wcjpk_pickup_house_number' )  );
	            $japakOrder->setShipmentHouseNumberAddon( get_option( 'wcjpk_pickup_house_number_addon' ) );	
	            $japakOrder->setShipmentPostalCode( get_option( 'wcjpk_pickup_postal' ) );
	            $japakOrder->setShipmentCity( get_option( 'wcjpk_pickup_city' ) );
	            $japakOrder->setShipmentCompany( get_option( 'wcjpk_pickup_company' ) );
            } else {
	            $japakOrder->setShipmentCountryCode( $orderMeta['_shipping_country'][0] );
	            $japakOrder->setShipmentEmail( $orderMeta['_billing_email'][0] );
	            $japakOrder->setShipmentPhone( $orderMeta['_billing_phone'][0] );
	
	            if (isset($orderMeta['_shipping_street_name'][0]) && strlen(trim($orderMeta['_shipping_street_name'][0])) > 0) {
	                $japakOrder->setShipmentStreet( $orderMeta['_shipping_street_name'][0] );
	            }
	
	            if (isset($orderMeta['_shipping_house_number'][0]) && strlen(trim($orderMeta['_shipping_house_number'][0])) > 0) {
	                $japakOrder->setShipmentHouseNumber( $orderMeta['_shipping_house_number'][0] );
	            }
	
	            if (isset($orderMeta['_shipping_house_number_suffix'][0]) && strlen(trim($orderMeta['_shipping_house_number_suffix'][0])) > 0) {
	                $japakOrder->setShipmentHouseNumberAddon( $orderMeta['_shipping_house_number_suffix'][0] );
	            }
	
	            $japakOrder->setShipmentPostalCode( $orderMeta['_shipping_postcode'][0] );
	            $japakOrder->setShipmentCity( $orderMeta['_shipping_city'][0] );
	            $japakOrder->setShipmentCompany( $orderMeta['_shipping_company'][0] );
	        }

            $japakWarehouseID = intval(get_option('wcjpk_warehouse_id', 0));
            $sendToOtherWarehouses = array();
            
            $japakItemCount = 0;
            
            foreach ($order->get_items() as $item_id => $item) {
	            $item_data = $item->get_data();

                $itemProductId = isset($item_data['variation_id']) && intval($item_data['variation_id']) > 0 ?
                    intval($item_data['variation_id']) : intval($item_data['product_id']);
	            	            				
				if ($itemProductId > 0) {
					$sku = get_post_meta($itemProductId, '_sku', true);
					
	                $productFields = get_fields($itemProductId);
	
	                if (isset($productFields['warehouse']) && intval($productFields['warehouse']) > 0) {
	                    if (intval($productFields['warehouse']) !== $japakWarehouseID) {
	
	                        if (isset($sendToOtherWarehouses[intval($productFields['warehouse'])])) {
	                            $sendToOtherWarehouses[intval($productFields['warehouse'])][] = $item_data;
	                        } else {
	                            $sendToOtherWarehouses[intval($productFields['warehouse'])] = array($item_data);
	                        }
	
	                        continue;
	                    }
	                }
	
	                $oderLine = new Japak_Objects_OrderLine();
	                $oderLine->setItemCode($sku);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setPrice($item_data['subtotal']);
	                } else {
	                    $oderLine->setPrice(0);
	                }
	
	                $oderLine->setAmount($item_data['quantity']);
	
	                if ($this->isPaymentsEnabled()) {
	                    $oderLine->setAmount($item_data['total']);
	                } else {
	                    $oderLine->setRowTotal(0);
	                }
	
	                $japakOrder->addOrderLine($oderLine);
	                $japakItemCount++;
				}
	        }

            if (count($sendToOtherWarehouses) > 0) {                
                foreach ($sendToOtherWarehouses as $warehouseId => $sendToOtherWarehouse) {	                
	                $warehouseEmail = get_field('warehouse_email', $warehouseId);
	                
	                if (strlen(trim($warehouseEmail)) > 0) {
						$subject = 'Bestelling ' . $order->get_order_number();
						
						$productsHtml = array();
						$noticeSkus = array();
						
						foreach ($sendToOtherWarehouse as $warehouseProduct) {
                            $itemProductId = isset($item_data['variation_id']) && intval($item_data['variation_id']) > 0 ?
                                intval($item_data['variation_id']) : intval($item_data['product_id']);

							$sku = get_post_meta($itemProductId, '_sku', true);
							$noticeSkus[] = $sku;
							$productsHtml[] = '<tr class="order_item">';
							$productsHtml[] = '<td class="td" style="text-align:left; vertical-align:middle; border: 1px solid #eee; font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif; word-wrap:break-word;">' . $sku . '</td>';
							$productsHtml[] = '<td class="td" style="text-align:left; vertical-align:middle; border: 1px solid #eee; font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif; word-wrap:break-word;">' . $item_data['name'] . '</td>';
							$productsHtml[] = '<td class="td" style="text-align:left; vertical-align:middle; border: 1px solid #eee; font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif;">' . $item_data['quantity'] . '</td>';
							$productsHtml[] = '</tr>';												
						}
						
						$body = '<table id="addresses" cellspacing="0" cellpadding="0" style="width: 100%; vertical-align: top;" border="0">
							<tr>
	
								<td class="td" style="text-align:left; font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif;" valign="top" width="50%">
									<h3>Bezorgadres</h3>
									<p class="text">' . $order->get_formatted_shipping_address() . '</p>
								</td>
							</tr>
						</table>
						<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: \'Helvetica Neue\', Helvetica, Roboto, Arial, sans-serif;" border="0">
							<thead>
								<tr>
									<th class="td" scope="col" style="text-align:left;">Nummer</th>
									<th class="td" scope="col" style="text-align:left;">Product</th>
									<th class="td" scope="col" style="text-align:left;">Aantal</th>
								</tr>
							</thead>
							<tbody>' . join('', $productsHtml) . '</tbody>
						</table>';
						
						if ($this->sendMail($warehouseEmail, $subject, $body, 'Bestelling #' . $order->get_order_number())) {
							// Add note
							$order->add_order_note('De product(en) ' . join(', ', $noticeSkus) . ' zijn verstuurd naar het magazijn met het e-mailadres ' . $warehouseEmail);
						}
	                }
                }
            }
            
            $japakOrder->addExtraField('OrderedByName', $orderMeta['_shipping_first_name'][0] . ' ' . $orderMeta['_shipping_last_name'][0]);
	        $japakOrder->addExtraField('OrderedByPhone', $orderMeta['_billing_phone'][0]);
	        $japakOrder->addExtraField('OrderedByCompany', $orderMeta['_shipping_company'][0]);
	        $japakOrder->addExtraField('OrderedByEmail', $orderMeta['_billing_email'][0]);
	        
	        if ( stripos(trim($order->get_shipping_method()), 'pickup') === 0 ) {
		        $japakOrder->addExtraField('OrderType', 'Pickup');
		    } else {
			    $japakOrder->addExtraField('OrderType', 'Delivery');
		    }
            
            if ($japakItemCount > 0) {
	            $xml = '<Orders>' . Japak_Serializer_OrderSerializer::serialize($japakOrder) . '</Orders>';
	
	            try {
	                $result = $this->getJapakCommunication()->sendRequest($xml);
	
	                if (isset($result->ResultCode) && (string)$result->ResultCode === 'I00') {
	                    // Add note
	                    $order->add_order_note('Bestelling is verstuurd naar Japak');
	
	                    // Update order status
	                    $order->update_status('completed');
	                } else {
	                    $order->add_order_note('Bestelling is niet verstuurd naar Japak. Foutmelding: ' . (string)$result->ResultDescription);
	                    throw new Exception((string)$result->ResultDescription);
	                }
	
	                return true;
	
	            } catch (Exception $ex) {
	                $this->writeFileLog('Send order exception: ' .  $ex->getMessage(), array('id' => $next->orderId), true);
	            }
            } else {
	            // Add note
	            $order->add_order_note('Bestelling hoeft niet naar Japak verstuurd te worden');
	            
	            // Update order status
	            $order->update_status('completed');
	                    
	            return true;
            }

            return false;
        }

        public function registerSettings()
        {
            foreach ($this->options as $key => $option) {
                register_setting('wcjpk-options', $key);
            }
        }

        //Access to page of Settings in menu Plugin
        public function loadSettings()
        {
            add_options_page(
                sprintf('%s Settings', PLUGIN_NAME_WOOCOMMERCE),
                'Japak Synchronisatie',
                'manage_options',
                WCJPK_PLUGIN_NAME,
                array($this, 'renderSettings')
            );
        }

        public function renderSettings()
        {
            include(WCJPK_PLUGIN_DIR.'templates/woocommerce-japak-settings.php');
        }

        //Obtain info of plugins and save information
        public function initPlugin()
        {
            $plugins = get_plugins();

            define('PLUGIN_NAME_WOOCOMMERCE', $plugins[WCJPK_PLUGIN]['Name']);
            define('PLUGIN_VERSION_WOOCOMMERCE', $plugins[WCJPK_PLUGIN]['Version']);
        }

        public function orderStatusChanged($orderId)
        {
            global $wpdb;
            
            $tableName =  $wpdb->prefix . WCJPK_DATABASE_ORDER_SYNC_TABLENAME;
            $exists = $wpdb->get_row("SELECT * FROM `$tableName` WHERE `orderId` = " . intval($orderId));
                        
            if (!$exists) {
	            $wpdb->insert(
	                $tableName,
	                array(
	                    'orderId' => $orderId,
	                    'created_at' => current_time('mysql')
	                )
	            );
            }
        }

        /**
         * Save post hook.
         *
         * @param integer $postId
         */
        public function savePost($postId)
        {
            $post = get_post($postId);

            // Check if the post type is product
            if ($post && $post->post_type === 'product' && !$this->stockInSync) {	            
                if ($this->syncProduct($post)) {
                    set_transient( 'wcjpk_product_synced', true, 3600 );
                }
            }
        }

        private function createOrderItem($productId, $sku, $descrition, $stock, $price, $imageUrl = false)
        {
            $item = new Japak_Objects_Item();
            $item->setItemCode($sku);
            $item->setDescription($descrition);
            $item->setBrand(get_option('wcjpk_brand'));
            $item->setBrandGroup(get_option('wcjpk_brand_group'));
            //$item->setStock($stock);
            $item->setPrice($price);

            if ($imageUrl) {
                $item->setImageURL($imageUrl);
            } else if (intval($productId) > 0) {
                $image = wp_get_attachment_image_src(get_post_thumbnail_id($productId), 'single-post-thumbnail');

                if ($image && isset($image[0])) {
                    $item->setImageURL($image[0]);
                }
            }

            return Japak_Serializer_ItemSerializer::serialize($item);
        }

        private function isJapakWarehouseProduct($productId)
        {
            // Check if the
            $productFields = get_fields($productId);

            if (isset($productFields['warehouse']) && intval($productFields['warehouse']) > 0) {
                if (intval($productFields['warehouse']) !== intval(get_option('wcjpk_warehouse_id', 0))) {
                    return false;
                }
            }

            return true;
        }

        /**
         * Synchronize product to Sherpa.
         *
         * @param object $product
         * @param bool $send
         * @return string|void
         */
        protected function syncProduct($post, $send = true)
        {	        
            // Not drafted products
            if (in_array($post->post_status, array('draft', 'auto-draft')) || !$this->isJapakWarehouseProduct($post->ID)) {
                return false;
            }

            $productFactory = new WC_Product_Factory();
            $product = $productFactory->get_product($post->ID);
            
            $mainProductId = $post->ID;
            $otherProductIds = array();

            $orderItems = array();

            if ($product->get_type() === 'variable') {
                /** @var WC_Product_Variation $product */
                foreach ($product->get_available_variations() as $variation) {
                    if ((int)$variation['variation_is_active'] !== 1 || strlen(trim($variation['sku'])) === 0) {
                        continue;
                    }

                    /** @var WC_Product_Variation $variationProduct */
                    $variationProductMeta = get_post_meta($variation['variation_id']);

                    $otherProductIds[] = $variation['variation_id'];

                    $orderItems[] = $this->createOrderItem(
                        false,
                        $variation['sku'],
                        (strlen(trim($variation['variation_description'])) > 0) ? $variation['variation_description'] : $product->get_name(),
                        $variationProductMeta['_stock'][0],
                        $variationProductMeta['_price'][0],
                        $variation['image']['url']
                    );
                }
            } else {
                /** @var WC_Product $product */
                $productMeta = get_post_meta($product->get_id());

                $orderItems[] = $this->createOrderItem(
                    $product->get_id(),
                    $productMeta['_sku'][0],
                    $product->get_name(),
                    $productMeta['_stock'][0],
                    $productMeta['_price'][0]
                );
            }
            
            $this->updateLowStockNotify($mainProductId, $otherProductIds);

            if (count($orderItems) === 0) {
                return;
            }

            $xml = implode('', $orderItems);

            if ($send) {
                try {
                    $response = $this->getJapakCommunication()->sendRequest('<Items>' . $xml . '</Items>');
                    $this->writeFileLog('Send product to sherpa: ' . $post->ID);
                } catch (Exception $ex) {
                    $this->writeFileLog('Sync. product Exception: ' .  $ex->getMessage(), array('id' => $post->ID, 'title' => $post->post_title), true);
                }
            } else {
                return $xml;
            }

            return true;
        }

        /**
         * Synchronize all products
         */
        protected function syncProducts()
        {
            // Get all products
            $products = get_posts(array(
                'post_type' => 'product',
                'posts_per_page' => -1
            ));

            $itemXML = array();
            $itemXML[] = '<Items CollectErrors="true">';

            foreach ($products as $product) {
                $productXml = $this->syncProduct($product, false);

                if ($productXml && is_string($productXml)) {
                    $itemXML[] = $productXml;
                }
            }

            $itemXML[] = '</Items>';
            $xml = join('', $itemXML);

            try {
                $this->getJapakCommunication()->sendRequest($xml);
                $this->writeFileLog('Products synced');
            } catch (Exception $ex) {
                $this->writeFileLog('Sync. products Exception: ' .  $ex->getMessage(), array(), true);
            }
        }

        /**
         * Write a string to log file.
         *
         * @param string $message
         */
        protected function writeFileLog($message, $extraData = array(), $mail = false)
        {
	        @date_default_timezone_set('Europe/Amsterdam');
	        
	        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			    $ip = $_SERVER['HTTP_CLIENT_IP'];
			} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			} else if(isset($_SERVER['REMOTE_ADDR'])) {
			    $ip = $_SERVER['REMOTE_ADDR'];
			} else {
				$ip = '';
			}

            $myFile = __DIR__.'/logs/logs-' . date('d-m-Y') . '.txt';
            $date = date('d-m-Y H:i:s');
            $message =  $date . " from " . $ip . " " . php_sapi_name() .  " : " . print_r($message, true) . "\r\n";
            
            if ($mail) {
	            if (@is_array($extraData) && @count($extraData) > 0) {
		            $message .= '<hr />';
		            $message .= '<pre>';
		            $message .= print_r($extraData, true);
		            $message .= '</pre>';
	            }
	            
	            $this->sendMail('errors@japak.nl', 'WriteFileLog', $message, 'WriteFileLog');
            }
            
            if (file_exists($myFile)) {
                $fh = @fopen($myFile, 'a') or die();
            } else {
                $fh = @fopen($myFile, 'w') or die();
            }

            @fwrite($fh, $message);
            @fclose($fh);
        }
    }
}