const path = require('path');
const MiniCssExtractPlugin = require("mini-css-extract-plugin");
const DependencyExtractionWebpackPlugin = require('@wordpress/dependency-extraction-webpack-plugin');

module.exports = (env, argv) => ({
  entry: {
    'main': './assets/src/js/main.js',
  },
  output: {
    path: path.resolve(__dirname, 'assets'),
    filename: 'js/[name].js',
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: "babel-loader"
      },
      {
        test: /\.scss$/,
        use: [
          MiniCssExtractPlugin.loader,
          "css-loader",
          "sass-loader"
        ]
      },
      {
        test: /\.(png|jpg|gif|woff|woff2|eot|ttf|svg)$/,
        loader: 'url-loader'
      }
    ]
  },
  plugins: [
    new MiniCssExtractPlugin({
      filename: "css/[name].css" // change this RELATIVE to your output.path!
    }),
    new DependencyExtractionWebpackPlugin({})
  ],
  devServer: {
    contentBase: path.join(__dirname, "dist"),
    compress: true,
    port: 8000
  },
  resolve: {
    alias: {
      '@/js': path.resolve(__dirname, './assets/src/js'),
      '@/scss': path.resolve(__dirname, './assets/src/scss'),
    },
    fallback: {
      'path': require.resolve('path-browserify')
    }
  },
  optimization: {
    minimize: argv.mode === 'production'
  }
});
