<?php

namespace ScfPriceUpdater;

use ScfPriceUpdater\Pages\Admin\DescriptionPage;
use ScfPriceUpdater\Pages\Admin\UpdaterPage;

class Core
{
    use SingletonTrait;

    protected function __construct()
    {
        add_action('init', [$this, 'init']);
        add_action('admin_init', [$this, 'adminInit']);

        add_filter('timber/locations', [$this, 'addTemplateLocations']);
    }

    public function init()
    {
        if (is_admin()) {
            new UpdaterPage();
            new DescriptionPage();
        }
    }

    public function adminInit()
    {
    }

    /**
     * Adds the template path locations to timber
     * @param $locations
     * @return mixed
     */
    public function addTemplateLocations($locations)
    {
        $locations[] = Assets::pluginPath() . 'templates/';
        $locations[] = Assets::pluginPath() . 'templates/admin/';

        return $locations;
    }
}
