<?php

namespace ScfPriceUpdater;

final class Assets
{

    /**
     * @param $name
     * @param array $additional_dependencies
     * @param bool $footer
     * @return void
     */
    public static function enqueueCompiledScript($name, array $additional_dependencies = [], bool $footer = true)
    {
        $asset_root = self::assetsPath();
        $js_src = '/js/' . $name . '.js';
        $css_src = '/css/' . $name . '.css';
        $asset_php_file = $asset_root . '/js/' . $name . '.asset.php';

        // check whether file exists
        if (!is_file($asset_root . $js_src) || !is_file($asset_php_file)) {
            return;
        }

        $asset_def = require($asset_php_file);

        wp_enqueue_script(
            $name,
            self::assetsUrl() . $js_src,
            [...$asset_def['dependencies'], ...$additional_dependencies],
            $asset_def['version'],
            $footer
        );

        if (is_file($asset_root . $css_src)) {
            wp_enqueue_style(
                $name,
                self::assetsUrl() . $css_src,
                [],
                $asset_def['version']
            );
        }
    }

    public static function assetsUrl(): string
    {
        return plugin_dir_url(__DIR__) . 'assets/';
    }

    public static function assetsPath(): string
    {
        return plugin_dir_path(__DIR__) . 'assets/';
    }

    public static function pluginUrl(): string
    {
        return plugin_dir_url(__DIR__);
    }

    public static function pluginPath(): string
    {
        return plugin_dir_path(__DIR__);
    }
}
