import '@/scss/main.scss'

import "@fortawesome/fontawesome-free/js/all.js";
import "@fortawesome/fontawesome-free/scss/fontawesome.scss";
import "@fortawesome/fontawesome-free/scss/solid.scss";
import "@fortawesome/fontawesome-free/scss/regular.scss";
import "@fortawesome/fontawesome-free/scss/brands.scss";

const fileUploadButton = document.getElementById('form-data-file');
const fileUploadResponse = document.getElementById('form-data-file-response');
const formDataResponse = document.getElementById('form-data-response');
const separatorInput = document.getElementById('form-data-separator');
const submitButton = document.getElementById('submit-update-prices');
const form = document.getElementById('price-updater-form');

fileUploadButton.addEventListener('change', (e) => {
    if (e.target.files && e.target.files[0]) {
        const file = e.target.files[0];
        if (file.type === "text/csv") {
            fileUploadResponse.classList.remove('error');
            fileUploadResponse.classList.add('success');
            fileUploadResponse.innerHTML = file.name;
        } else {
            fileUploadButton.value = '';
            fileUploadResponse.classList.add('error');
            fileUploadResponse.classList.remove('success');
            fileUploadResponse.innerHTML = `${file.name} is not a valid CSV file!`;
        }
    }
});

submitButton.addEventListener('click', (e) => {
    if (separatorInput.value.length > 0) {
        if (fileUploadButton.files && fileUploadButton.files[0]) {
            const file = fileUploadButton.files[0];
            if (file.type === "text/csv") {
                submitButton.innerHTML = `<i class="fas fa-circle-notch fa-spin"></i>`;
                form.submit();
            } else {
                formDataResponse.classList.add('error');
                formDataResponse.classList.remove('success');
                formDataResponse.innerHTML = `${file.name} is not a valid CSV file!`;
            }
        } else {
            formDataResponse.classList.add('error');
            formDataResponse.classList.remove('success');
            formDataResponse.innerHTML = `No upload was found!`;
        }
    } else {
        formDataResponse.classList.add('error');
        formDataResponse.classList.remove('success');
        formDataResponse.innerHTML = `No separator input, this is needed to separate SKU from Prices`;
    }
});