<?php

namespace RTMBusiness\UserSpecificContent;

/**
 * User specific content Extention class to SimplePanel 0.3.2
 *
 * @version 0.1
 * @author Ohad Raz <admin@bainternet.info>
 * @copyright 2013 Ohad Raz
 *
 */
class UserSpecificContentPanel extends SimplePanel
{

    public function admin_menu(): void
    {
        $this->slug = add_users_page(
            $this->title,
            $this->name,
            $this->capability,
            get_class(),
            array($this, 'show_page')
        );

        //help tabs
        add_action('load-' . $this->slug, [$this, '_help_tab']);
        add_action(get_class() . 'add_meta_boxes', [$this, 'add_meta_boxes']);
    }

    /**
     * add_meta_boxes to page
     */
    public function add_meta_boxes()
    {
        add_meta_box(
            'Save_settings',
            __('Save Settings', $this->localization_domain),
            [$this, 'render_save_settings'],
            get_class(),
            'side',
            'low'
        );
        foreach ($this->sections as $s) {
            add_meta_box(
                $s['id'],
                $s['title'],
                [$this, 'render_main_settings'],
                get_class(),
                'normal',
                'low',
                $s);
        }
    }

    /**
     * generate plugin button metabox
     * @return void
     */
    public function render_save_settings(): void
    {
        submit_button('Save Changes');
    }

    /**
     * main settings metaboxs
     * @return [type] [description]
     */
    function render_main_settings($args, $s = null)
    {

        echo '<table class="form-table">';
        do_settings_fields(get_class(), $s['id']);
        echo '</table>';
    }

    public function show_page()
    {
        wp_enqueue_script('post');
        do_action(get_class() . 'add_meta_boxes');

        if (isset($this->inject['before_wrap'])) {
            echo $this->inject['before_wrap'];
        }
        ?>

        <div class="wrap">
            <h2><?php echo $this->name; ?></h2>
            <div id="message" class="below-h2"></div>
            <?php settings_errors(); ?>
            <?php do_action($this->slug . '_before_Form', $this); ?>
            <form id="BPM_FORM" action="options.php" method="POST">
                <div id="poststuff" class="metabox-holder has-right-sidebar">
                    <div class="inner-sidebar">
                        <!-- SIDEBAR BOXES -->
                        <?php do_action($this->slug . '_before_sidebar', $this); ?>
                        <?php do_meta_boxes(get_class(), 'side', $this); ?>
                        <?php do_action($this->slug . '_after_sidebar', $this); ?>
                    </div>
                    <div id="post-body" style="background-color: transparent;">
                        <div id="post-body-content">
                            <div id="titlediv"></div>
                            <div id="postdivrich" class="postarea"></div>
                            <div id="normal-sortables" class="meta-box-sortables ui-sortable">
                                <!-- BOXES -->
                                <?php do_action($this->slug . '_before_metaboxes', $this); ?>
                                <?php
                                foreach ($this->sections as $s) {
                                    settings_fields($s['option_group']);
                                }
                                do_meta_boxes(get_class(), 'normal', $this);
                                ?>
                                <?php do_action($this->slug . '_after_metaboxes', $this); ?>
                            </div>
                        </div>
                    </div>
                    <br class="clear">
                </div>
                <?php do_action($this->slug . '_after_Fields', $this); ?>
            </form>
            <?php do_action($this->slug . '_after_Form', $this); ?>
        </div>
        <?php
        if (isset($this->inject['after_wrap']))
            echo $this->inject['after_wrap'];
        ?>
        <style>
            .error {
                background-color: #FFEBE8;
                border-color: #C00;
            }

            .error input, .error textarea {
                border-color: #C00;
            }
        </style>
        <?php
    }

    /**
     * Register settings section for the plugin and all setting fields
     */
    public function register_settings(): void
    {
        foreach ($this->sections as $s) {
            add_settings_section($s['id'], $s['title'], array($this, 'section_callback'), get_class());
            register_setting($s['option_group'], $this->option, array($this, 'sanitize_callback'));
        }
        foreach ($this->fields as $f) {
            add_settings_field($f['id'], $f['label'], array($this, 'show_field'), get_class(), $f['section'], $f);
        }
    }

    /**
     * Register the sections for the options page.
     */
    public function register_options_sections()
    {
        $general_settings_id = $this->add_section([
                'option_group' => 'U_S_C',
                'sanitize_callback' => null,
                'id' => 'U_S_C',
                'title' => __('General settings:', $this->localization_domain)
            ]
        );

        $this->add_general_settings_fields($general_settings_id);

        $metabox_settings_id = $this->add_section(array(
                'option_group' => 'U_S_C',
                'sanitize_callback' => null,
                'id' => 'U_S_C_metabox',
                'title' => __('Post Metabox settings', $this->localization_domain)
            )
        );

        $this->add_metabox_settings_fields($metabox_settings_id);
    }

    /**
     * Add the fields for the general settings section.
     * @param $section_id
     */
    public function add_general_settings_fields($section_id)
    {
        $this->add_field([
                'label' => __('Global Blocked message:', $this->localization_domain),
                'std' => '',
                'id' => 'b_message',
                'type' => 'textarea',
                'section' => $section_id,
                'desc' => __('(if set in a metabox the it overwrites this message for that specific post/page)', $this->localization_domain)
            ]
        );
    }

    /**
     * Add the fields for the metabox settings section.
     * @param $section_id
     */
    public function add_metabox_settings_fields($section_id)
    {
        // fetch public post types
        $output = 'objects';
        $args = ['public' => true];
        $post_types = get_post_types($args, $output);

        foreach ($post_types as $k => $post_type) {
            $this->add_field(array(
                    'label' => __('Enable on  ' . $post_type->label, $this->localization_domain),
                    'std' => true,
                    'id' => 'posttypes][' . $post_type->name,
                    'type' => 'checkbox',
                    'section' => $section_id,
                )
            );
        }
    }

}

