<?php 
/* section main */
if ( !defined('ABSPATH')) exit;

$domain = 'rtm-usc';
$setting = $p->add_section(array(
	'option_group'      =>  'U_S_C',
	'sanitize_callback' => null,
	'id'                => 'U_S_C', 
	'title'             => __('General settings:', $domain)
	)
);

//textarea field
$p->add_field(array(
    'label'   => __('Global Blocked message:', $domain),
    'std'     => '',
    'id'      => 'b_massage',
    'type'    => 'textarea',
    'section' => $setting,
    'desc'    => __('(if set in a metabox the it overwrites this message for that specific post/page)', $domain)
    )
);

//checkbox field

$setting2 = $p->add_section(array(
	'option_group'      =>  'U_S_C',
	'sanitize_callback' => null,
	'id'                => 'U_S_C_metabox', 
	'title'             => __('MetaBox settings', $domain)
	)
);

//checkbox field
$p->add_field(array(
    'label'   => __('List user names?', $domain),
    'std'     => true,
    'id'      => 'list_users',
    'type'    => 'checkbox',
    'section' => $setting2,
    'desc'    => __('(default checked) sites with a large number of users should uncheck this option', $domain)
    )
);
//select field
$p->add_field(array(
    'label'   => __('User List Type', $domain),
    'std'     => 'checkbox',
    'id'      => 'user_list_type',
    'type'    => 'select',
    'section' => $setting2,
    'options' => array(__('Select', $domain)=>'select',__('Checkboxes', $domain) => 'checkbox'),
    'desc'    => __('Select the field type of the user list', $domain)
    )
);


$p->add_field(array(
    'label'   => __('List user roles?', $domain),
    'std'     => true,
    'id'      => 'list_roles',
    'type'    => 'checkbox',
    'section' => $setting2,
    'desc'    => __('(default checked) sites with a large number of roles should uncheck this option', $domain)
    )
);

//select field
$p->add_field(array(
    'label'   => __('User Roles List Type', $domain),
    'std'     => 'checkbox',
    'id'      => 'user_role_list_type',
    'type'    => 'select',
    'section' => $setting2,
    'options' => array(__('Select', $domain)=>'select',__('Checkboxes', $domain) => 'checkbox'),
    'desc'    => __('Select the field type of the user list', $domain)
    )
);

global $wp_roles;
$capabilities = array();
foreach ($wp_roles->roles as $role => $r) {
	foreach ((array)$r['capabilities'] as $key => $value) {
		$capabilities[$key] = $key;
	}
}
//select field
$p->add_field(array(
    'label'   => __('Capability'),
    'std'     => 'manage_options',
    'id'      => 'capability',
    'type'    => 'select',
    'section' => $setting2,
    'options' => $capabilities,
    'desc'    => __('Capability needed to see and manage the metabox', $domain)
    )
);

$args = array(
//   'public'   => true,
//   '_builtin' => false
);
$output = 'objects'; // names or objects, note names is the default
$operator = 'and'; // 'and' or 'or'
$post_types = get_post_types( $args, $output );

foreach ( $post_types  as $k => $post_type ) {
	$p->add_field(array(
		'label'   => __('Enable on  ' . $post_type->label, $domain),
		'std'     => true,
		'id'      => 'posttypes]['.$post_type->name,
		'type'    => 'checkbox',
		'section' => $setting2,
		)
	);
}